/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base16;

public class APLRecord
extends Record {
    private static final long serialVersionUID = -1348173791712935864L;
    private List elements;

    APLRecord() {
    }

    Record getObject() {
        return new APLRecord();
    }

    private static boolean validatePrefixLength(int family, int prefixLength) {
        if (prefixLength < 0 || prefixLength >= 256) {
            return false;
        }
        return (family != 1 || prefixLength <= 32) && (family != 2 || prefixLength <= 128);
    }

    public APLRecord(Name name, int dclass, long ttl, List elements) {
        super(name, 42, dclass, ttl);
        this.elements = new ArrayList(elements.size());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) {
                throw new IllegalArgumentException("illegal element");
            }
            Element element = (Element)o;
            if (element.family != 1 && element.family != 2) {
                throw new IllegalArgumentException("unknown family");
            }
            this.elements.add(element);
        }
    }

    private static byte[] parseAddress(byte[] in, int length) throws WireParseException {
        if (in.length > length) {
            throw new WireParseException("invalid address length");
        }
        if (in.length == length) {
            return in;
        }
        byte[] out = new byte[length];
        System.arraycopy(in, 0, out, 0, in.length);
        return out;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.elements = new ArrayList(1);
        while (in.remaining() != 0) {
            Element element;
            int family = in.readU16();
            int prefix = in.readU8();
            int length = in.readU8();
            boolean negative = (length & 0x80) != 0;
            byte[] data = in.readByteArray(length &= 0xFFFFFF7F);
            if (!APLRecord.validatePrefixLength(family, prefix)) {
                throw new WireParseException("invalid prefix length");
            }
            if (family == 1 || family == 2) {
                data = APLRecord.parseAddress(data, Address.addressLength(family));
                InetAddress addr = InetAddress.getByAddress(data);
                element = new Element(negative, addr, prefix);
            } else {
                element = new Element(family, negative, data, prefix);
            }
            this.elements.add(element);
        }
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.elements = new ArrayList(1);
        while ((t = st.get()).isString()) {
            int colon;
            boolean negative = false;
            int family = 0;
            int prefix = 0;
            String s = t.value;
            int start = 0;
            if (s.startsWith("!")) {
                negative = true;
                start = 1;
            }
            if ((colon = s.indexOf(58, start)) < 0) {
                throw st.exception("invalid address prefix element");
            }
            int slash = s.indexOf(47, colon);
            if (slash < 0) {
                throw st.exception("invalid address prefix element");
            }
            String familyString = s.substring(start, colon);
            String addressString = s.substring(colon + 1, slash);
            String prefixString = s.substring(slash + 1);
            try {
                family = Integer.parseInt(familyString);
            }
            catch (NumberFormatException e) {
                throw st.exception("invalid family");
            }
            if (family != 1 && family != 2) {
                throw st.exception("unknown family");
            }
            try {
                prefix = Integer.parseInt(prefixString);
            }
            catch (NumberFormatException e) {
                throw st.exception("invalid prefix length");
            }
            if (!APLRecord.validatePrefixLength(family, prefix)) {
                throw st.exception("invalid prefix length");
            }
            byte[] bytes = Address.toByteArray(addressString, family);
            if (bytes == null) {
                throw st.exception("invalid IP address " + addressString);
            }
            InetAddress address = InetAddress.getByAddress(bytes);
            this.elements.add(new Element(negative, address, prefix));
        }
        st.unget();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            sb.append(element);
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List getElements() {
        return this.elements;
    }

    private static int addressLength(byte[] addr) {
        for (int i = addr.length - 1; i >= 0; --i) {
            if (addr[i] == 0) continue;
            return i + 1;
        }
        return 0;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            byte[] data;
            Element element = (Element)it.next();
            int length = 0;
            if (element.family == 1 || element.family == 2) {
                InetAddress addr = (InetAddress)element.address;
                data = addr.getAddress();
                length = APLRecord.addressLength(data);
            } else {
                data = (byte[])element.address;
                length = data.length;
            }
            int wlength = length;
            if (element.negative) {
                wlength |= 0x80;
            }
            out.writeU16(element.family);
            out.writeU8(element.prefixLength);
            out.writeU8(wlength);
            out.writeByteArray(data, 0, length);
        }
    }

    public static class Element {
        public final int family;
        public final boolean negative;
        public final int prefixLength;
        public final Object address;

        private Element(int family, boolean negative, Object address, int prefixLength) {
            this.family = family;
            this.negative = negative;
            this.address = address;
            this.prefixLength = prefixLength;
            if (!APLRecord.validatePrefixLength(family, prefixLength)) {
                throw new IllegalArgumentException("invalid prefix length");
            }
        }

        public Element(boolean negative, InetAddress address, int prefixLength) {
            this(Address.familyOf(address), negative, address, prefixLength);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.negative) {
                sb.append("!");
            }
            sb.append(this.family);
            sb.append(":");
            if (this.family == 1 || this.family == 2) {
                sb.append(((InetAddress)this.address).getHostAddress());
            } else {
                sb.append(base16.toString((byte[])this.address));
            }
            sb.append("/");
            sb.append(this.prefixLength);
            return sb.toString();
        }

        public boolean equals(Object arg) {
            if (arg == null || !(arg instanceof Element)) {
                return false;
            }
            Element elt = (Element)arg;
            return this.family == elt.family && this.negative == elt.negative && this.prefixLength == elt.prefixLength && this.address.equals(elt.address);
        }

        public int hashCode() {
            return this.address.hashCode() + this.prefixLength + (this.negative ? 1 : 0);
        }
    }
}

