/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CShiftData;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CContentOutlinerProvider
extends BaseCElementContentProvider {
    TreeViewer treeViewer;
    ITranslationUnit root;
    private ElementChangedListener fListener;
    private IPropertyChangeListener fPropertyListener;
    private boolean fInitialDeltaPending;

    public CContentOutlinerProvider(TreeViewer viewer) {
        this(viewer, null);
    }

    public CContentOutlinerProvider(TreeViewer viewer, IWorkbenchPartSite site) {
        super(true, true, true, () -> CContentOutlinerProvider.isSorted(viewer));
        this.treeViewer = viewer;
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.setIncludesGrouping(store.getBoolean("org.eclipse.cdt.ui.outline.groupincludes"));
        this.setNamespacesGrouping(store.getBoolean("org.eclipse.cdt.ui.outline.groupnamespaces"));
        this.setMemberGrouping(store.getBoolean("org.eclipse.cdt.ui.outline.groupmembers"));
        this.setMacroGrouping(store.getBoolean("org.eclipse.cdt.ui.outline.groupmacros"));
        this.setHidePragmaMark(store.getBoolean("org.eclipse.cdt.ui.outline.hidePragmaMark"));
    }

    private static boolean isSorted(TreeViewer viewer) {
        return viewer != null && viewer.getComparator() != null;
    }

    public void contentUpdated() {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.getControl().getDisplay().asyncExec(() -> {
                if (!this.treeViewer.getControl().isDisposed()) {
                    if (this.fInitialDeltaPending) {
                        this.fInitialDeltaPending = false;
                        this.treeViewer.setInput((Object)this.root);
                    } else {
                        this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    public void contentShift(CShiftData sdata) {
        try {
            ICElement[] el = this.root.getChildren();
            int i = 0;
            while (i < el.length) {
                if (el[i] instanceof SourceManipulation) {
                    SourceManipulation sm = (SourceManipulation)el[i];
                    ISourceRange src = sm.getSourceRange();
                    int endOffset = src.getStartPos() + src.getLength();
                    if (sdata.getOffset() <= endOffset) {
                        if (sdata.getOffset() < src.getStartPos()) {
                            sm.setIdPos(src.getIdStartPos() + sdata.getSize(), src.getIdLength());
                            sm.setPos(src.getStartPos() + sdata.getSize(), src.getLength());
                            sm.setLines(src.getStartLine() + sdata.getLines(), src.getEndLine() + sdata.getLines());
                        } else {
                            sm.setPos(src.getStartPos(), src.getLength() + sdata.getSize());
                            sm.setLines(src.getStartLine(), src.getEndLine() + sdata.getLines());
                        }
                    }
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
        if (this.fPropertyListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isTU = newInput instanceof ITranslationUnit;
        if (isTU) {
            this.root = (ITranslationUnit)newInput;
            if (this.fListener == null) {
                this.fListener = new ElementChangedListener();
                CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fListener);
                this.fPropertyListener = new PropertyListener();
                PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
            }
        } else {
            if (this.fListener != null) {
                CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
                PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
                this.fListener = null;
                this.fPropertyListener = null;
            }
            this.root = null;
        }
    }

    @Override
    public Object[] getChildren(Object element) {
        ITranslationUnit unit;
        Object[] children = null;
        if (element instanceof ITranslationUnit && !(unit = (ITranslationUnit)element).isOpen()) {
            this.fInitialDeltaPending = true;
            children = new Object[]{new PendingUpdateAdapter()};
        }
        if (children == null) {
            children = super.getChildren(element);
        }
        return children;
    }

    @Override
    public boolean hasChildren(Object element) {
        return super.hasChildren(element);
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList<ICElement> newSelection = new ArrayList<ICElement>();
        if (sel instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)sel) {
                if (!(o instanceof ICElement)) continue;
                newSelection.add((ICElement)o);
            }
        }
        return new StructuredSelection(newSelection);
    }

    class ElementChangedListener
    implements IElementChangedListener {
        public void elementChanged(ElementChangedEvent e) {
            if (e.getType() == 5 && e.getDelta() instanceof CShiftData) {
                CContentOutlinerProvider.this.contentShift((CShiftData)e.getDelta());
                return;
            }
            ICElementDelta delta = this.findElement((ICElement)CContentOutlinerProvider.this.root, e.getDelta());
            if (delta != null) {
                CContentOutlinerProvider.this.contentUpdated();
            }
        }

        private boolean isPossibleStructuralChange(ICElementDelta cuDelta) {
            int flags;
            boolean ret = cuDelta.getKind() != 4 ? true : (((flags = cuDelta.getFlags()) & 8) != 0 ? true : (flags & 0x400001) == 1);
            return ret;
        }

        protected ICElementDelta findElement(ICElement unit, ICElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            ICElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 60) {
                return null;
            }
            ICElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            ICElementDelta[] iCElementDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ICElementDelta element2 = iCElementDeltaArray[n2];
                ICElementDelta d = this.findElement(unit, element2);
                if (d != null) {
                    return d;
                }
                ++n2;
            }
            return null;
        }
    }

    class PropertyListener
    implements IPropertyChangeListener {
        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object newValue;
            String prop = event.getProperty();
            if (prop.equals("org.eclipse.cdt.ui.outline.groupincludes")) {
                Object newValue2 = event.getNewValue();
                if (newValue2 instanceof Boolean) {
                    boolean value = (Boolean)newValue2;
                    if (CContentOutlinerProvider.this.areIncludesGroup() != value) {
                        CContentOutlinerProvider.this.setIncludesGrouping(value);
                        CContentOutlinerProvider.this.contentUpdated();
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.groupnamespaces")) {
                Object newValue3 = event.getNewValue();
                if (newValue3 instanceof Boolean) {
                    boolean value = (Boolean)newValue3;
                    if (CContentOutlinerProvider.this.areNamespacesGroup() != value) {
                        CContentOutlinerProvider.this.setNamespacesGrouping(value);
                        CContentOutlinerProvider.this.contentUpdated();
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.groupmembers")) {
                Object newValue4 = event.getNewValue();
                if (newValue4 instanceof Boolean) {
                    boolean value = (Boolean)newValue4;
                    if (CContentOutlinerProvider.this.isMemberGroupingEnabled() != value) {
                        CContentOutlinerProvider.this.setMemberGrouping(value);
                        CContentOutlinerProvider.this.contentUpdated();
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.groupmacros")) {
                Object newValue5 = event.getNewValue();
                if (newValue5 instanceof Boolean) {
                    boolean value = (Boolean)newValue5;
                    if (CContentOutlinerProvider.this.isMacroGroupingEnabled() != value) {
                        CContentOutlinerProvider.this.setMacroGrouping(value);
                        CContentOutlinerProvider.this.contentUpdated();
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.hidePragmaMark") && (newValue = event.getNewValue()) instanceof Boolean) {
                boolean value = (Boolean)newValue;
                if (CContentOutlinerProvider.this.isHidePragmaMarkEnabled() != value) {
                    CContentOutlinerProvider.this.setHidePragmaMark(value);
                    CContentOutlinerProvider.this.contentUpdated();
                }
            }
        }
    }
}

