/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.editing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.common.tools.api.editing.DefaultEditingDomainFactory;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryDescriptor;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryRegistry;
import org.eclipse.sirius.common.tools.api.editing.IEditingDomainFactory;

public final class EditingDomainFactoryService {
    public static final EditingDomainFactoryService INSTANCE = new EditingDomainFactoryService();

    public IEditingDomainFactory getEditingDomainFactory() {
        IEditingDomainFactory result = null;
        List<EditingDomainFactoryDescriptor> editingDomainFactoryDescriptors = EditingDomainFactoryRegistry.getRegisteredExtensions();
        if (editingDomainFactoryDescriptors.isEmpty()) {
            result = new DefaultEditingDomainFactory();
        } else {
            EditingDomainFactoryDescriptor editingDomainFactoryDescriptor = this.getFirstMostOverrider(editingDomainFactoryDescriptors);
            result = editingDomainFactoryDescriptor.getEditingDomainFactory();
        }
        return result;
    }

    private EditingDomainFactoryDescriptor getFirstMostOverrider(List<EditingDomainFactoryDescriptor> editingDomainFactoryDescriptors) {
        ArrayList<String> overriddenEditingDomainFactoryIDs = new ArrayList<String>();
        EditingDomainFactoryDescriptor firstMostPriorityEditingDomainFactoryDescriptor2 = null;
        for (EditingDomainFactoryDescriptor firstMostPriorityEditingDomainFactoryDescriptor2 : editingDomainFactoryDescriptors) {
            String overrideValue = firstMostPriorityEditingDomainFactoryDescriptor2.getOverrideValue();
            if (overrideValue == null) continue;
            overriddenEditingDomainFactoryIDs.add(overrideValue);
        }
        for (EditingDomainFactoryDescriptor firstMostPriorityEditingDomainFactoryDescriptor2 : editingDomainFactoryDescriptors) {
            if (overriddenEditingDomainFactoryIDs.contains(firstMostPriorityEditingDomainFactoryDescriptor2.getId())) continue;
            return firstMostPriorityEditingDomainFactoryDescriptor2;
        }
        return firstMostPriorityEditingDomainFactoryDescriptor2;
    }
}

