/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.ecore.EPackageMetaData;

public final class EPackageHelper {
    private EPackageHelper() {
    }

    public static List<EClass> getConcreteClasses(EPackage ePackage) {
        ArrayList<EClass> concreteClasses = new ArrayList<EClass>();
        if (ePackage != null) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || ((EClass)eClassifier).isAbstract() || ((EClass)eClassifier).isInterface() || !((EClass)eClassifier).getEAllReferences().stream().anyMatch(EReference::isContainment)) continue;
                concreteClasses.add((EClass)eClassifier);
            }
        }
        return concreteClasses;
    }

    public static List<EClass> getEClassRootElements(EPackage ePackage) {
        List<EClass> concreteClasses = EPackageHelper.getConcreteClasses(ePackage);
        if (ePackage != null) {
            String nsURI = ePackage.getNsURI();
            EPackageMetaData metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(nsURI);
            List<Object> roots = new ArrayList<EClass>();
            if (metaData != null && !metaData.getSuggestedRoots().isEmpty()) {
                roots = concreteClasses.stream().filter(c -> metaData.getSuggestedRoots().contains(c.getName())).collect(Collectors.toList());
            }
            if (!roots.isEmpty()) {
                return roots;
            }
        }
        final Map<EClass, Integer> inferredRootElementsCandidates = EPackageHelper.inferRootElementsCandidates(ePackage, concreteClasses);
        ArrayList<EClass> sortedResults = new ArrayList<EClass>();
        sortedResults.addAll(inferredRootElementsCandidates.keySet());
        Collections.sort(sortedResults, new Comparator<EClass>(){

            @Override
            public int compare(EClass eClass1, EClass eClass2) {
                return ((Integer)inferredRootElementsCandidates.get(eClass2)).compareTo((Integer)inferredRootElementsCandidates.get(eClass1));
            }
        });
        return sortedResults;
    }

    private static Map<EClass, Integer> inferRootElementsCandidates(EPackage ePackage, Collection<EClass> concreteClasses) {
        HashMap<EClass, Integer> eClassToRootScore = new HashMap<EClass, Integer>();
        if (ePackage != null) {
            List<EClass> allClasses = ePackage.getEClassifiers().stream().filter(c -> c instanceof EClass).map(c -> (EClass)c).collect(Collectors.toList());
            for (EClass eClass : concreteClasses) {
                int importance;
                if (!eClass.getEAllReferences().stream().anyMatch(EReference::isContainment) || (importance = EPackageHelper.getReferenceScore(eClass, allClasses)) == -1) continue;
                eClassToRootScore.put(eClass, importance);
            }
        }
        return eClassToRootScore;
    }

    private static int getReferenceScore(EClass eClassToTest, Collection<EClass> allEClasses) {
        EList targetReferences = eClassToTest.getEAllReferences();
        int score = 0;
        Iterator<EClass> allEClassesIte = allEClasses.iterator();
        while (allEClassesIte.hasNext() && score != -1) {
            EClass eClass = allEClassesIte.next();
            Set references = eClass.getEAllReferences().stream().filter(EReference::isContainment).collect(Collectors.toSet());
            Iterator referencesIte = references.iterator();
            while (referencesIte.hasNext() && score != -1) {
                HashSet<EClass> eClassCheckedSet;
                boolean isReferenced;
                EReference eReference = (EReference)referencesIte.next();
                EClassifier referedClassifier = eReference.getEType();
                boolean typeReferenced = eClassToTest.getEAllSuperTypes().contains((Object)referedClassifier) || eClassToTest.equals(referedClassifier);
                boolean notReferencedByEClassSuperType = !eClass.isSuperTypeOf(eClassToTest);
                boolean notReferencedByAContainedEClass = !targetReferences.stream().anyMatch(ref -> ref.isContainment() && (eClass.getEAllSuperTypes().contains((Object)ref.getEType()) || eClass.equals(ref.getEType())));
                boolean bl = isReferenced = typeReferenced && notReferencedByEClassSuperType && notReferencedByAContainedEClass;
                if (!isReferenced || EPackageHelper.eClassContainsRecursively(eClassToTest, eClass, eClassCheckedSet = new HashSet<EClass>())) continue;
                score = -1;
            }
        }
        if (score == 0) {
            HashSet<EClass> eClassCheckedSet = new HashSet<EClass>();
            score = EPackageHelper.computeScoreRecursively(eClassToTest, eClassCheckedSet);
        }
        return score;
    }

    private static int computeScoreRecursively(EClass targetEClass, Set<EClass> eClassCheckedSet) {
        int score = 0;
        if (!eClassCheckedSet.contains(targetEClass)) {
            eClassCheckedSet.add(targetEClass);
            EList eAllReferences = targetEClass.getEAllReferences();
            for (EReference eReference : eAllReferences) {
                if (!eReference.isContainment()) continue;
                ++score;
                EClassifier eType = eReference.getEType();
                if (!(eType instanceof EClass)) continue;
                score += EPackageHelper.computeScoreRecursively((EClass)eType, eClassCheckedSet);
            }
        }
        return score;
    }

    private static boolean eClassContainsRecursively(EClass targetEClass, EClass eClassContainedRecursively, Set<EClass> eClassCheckedSet) {
        boolean containedRecursively = false;
        if (!eClassCheckedSet.contains(targetEClass)) {
            eClassCheckedSet.add(targetEClass);
            EList eAllReferences = targetEClass.getEAllReferences();
            HashSet<EClass> referencedEClasses = new HashSet<EClass>();
            for (EReference eReference : eAllReferences) {
                EClassifier eType = eReference.getEType();
                if (!eReference.isContainment() || !(eType instanceof EClass)) continue;
                EClass referencedEClass = (EClass)eType;
                referencedEClasses.add(referencedEClass);
                if (!eClassContainedRecursively.equals(referencedEClass) && !eClassContainedRecursively.getEAllSuperTypes().contains((Object)referencedEClass)) continue;
                return true;
            }
            Iterator referecedEClassesIte = referencedEClasses.iterator();
            while (referecedEClassesIte.hasNext() && !containedRecursively) {
                EClass referencedEClass = (EClass)referecedEClassesIte.next();
                containedRecursively = EPackageHelper.eClassContainsRecursively(referencedEClass, eClassContainedRecursively, eClassCheckedSet);
            }
        }
        return containedRecursively;
    }

    public static EClass getPreferredRootElementFromEPackageExtraData(EPackage ePackage) {
        EClassifier result;
        String nsURI;
        EPackageMetaData metaData;
        if (ePackage != null && (metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(nsURI = ePackage.getNsURI())) != null && !metaData.getSuggestedRoots().isEmpty() && (result = ePackage.getEClassifier(metaData.getSuggestedRoots().get(0))) instanceof EClass) {
            return (EClass)result;
        }
        return null;
    }
}

