/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class CheckoutNodeWizardPage
extends WizardPage {
    protected final String title;
    private TreeViewer nodeViewer;
    private boolean nodeRevealed;
    private Object node;

    public CheckoutNodeWizardPage(String pageName, String title, IStructuredSelection selection) {
        super(pageName);
        this.title = title;
        this.node = CheckoutNodeWizardPage.getNode(selection);
    }

    public final Object getNode() {
        return this.node;
    }

    public final TreeViewer getNodeViewer() {
        return this.nodeViewer;
    }

    public void createControl(Composite parent) {
        this.setTitle(this.title);
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        containerGridLayout.numColumns = 2;
        container.setLayout((Layout)containerGridLayout);
        this.setControl((Control)container);
        this.doCreateControl(container);
        Shell shell = this.getShell();
        UIUtil.asyncExec((Display)shell.getDisplay(), () -> {
            try {
                shell.setText(this.title);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.revealNode();
            this.validate();
            this.deferredInit();
        });
    }

    protected void doCreateControl(Composite parent) {
        Label nodeLabel = new Label(parent, 0);
        nodeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        nodeLabel.setText(this.getNodeMessage() + ":");
        this.nodeViewer = this.createNodeViewer(parent);
        this.nodeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.nodeViewer.addSelectionChangedListener(event -> this.nodeSelectionChanged(event));
    }

    protected abstract String getNodeMessage();

    protected TreeViewer createNodeViewer(Composite container) {
        return CDOCheckoutContentProvider.createTreeViewer(container);
    }

    protected void deferredInit() {
    }

    protected final Pair<CDOCheckout, CDOResourceNode> getNodeInfo() {
        CDOResourceNode parentNode;
        CDOCheckout checkout;
        if (this.node instanceof CDOCheckout) {
            CDOCheckout checkout2 = (CDOCheckout)this.node;
            EObject parentNode2 = checkout2.getRootObject();
            if (parentNode2 instanceof CDOResourceNode) {
                return Pair.create((Object)checkout2, (Object)((CDOResourceNode)parentNode2));
            }
        } else if (this.node instanceof CDOResourceNode && (checkout = CDOExplorerUtil.getCheckout((Object)(parentNode = (CDOResourceNode)this.node))) != null) {
            return Pair.create((Object)checkout, (Object)parentNode);
        }
        return null;
    }

    protected final EList<EObject> getNodeChildren() {
        if (this.node instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)this.node;
            return checkout.getRootObject().eContents();
        }
        if (this.node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)this.node;
            return folder.eContents();
        }
        return ECollections.emptyEList();
    }

    protected final void validate() {
        try {
            this.doValidate();
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
            this.setPageComplete(false);
        }
    }

    protected void doValidate() throws Exception {
        if (this.node == null) {
            throw new Exception(this.getNodeMessage() + ".");
        }
    }

    private void nodeSelectionChanged(SelectionChangedEvent event) {
        Object oldNode = this.node;
        if (this.nodeRevealed) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.node = CheckoutNodeWizardPage.getNode(selection);
        }
        if (!Objects.equals(this.node, oldNode)) {
            this.nodeSelectionChanged(oldNode, this.node);
        }
        this.validate();
    }

    protected void nodeSelectionChanged(Object oldNode, Object newNode) {
    }

    private void revealNode() {
        if (this.node != null) {
            ArrayList<Object> segments = new ArrayList<Object>();
            this.fillSegments(segments, this.node);
            int i = 0;
            while (i < segments.size() - 1) {
                Object segment = segments.get(i);
                this.nodeViewer.setExpandedState(segment, true);
                ++i;
            }
        } else {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.nodeViewer.getContentProvider();
            Object[] elements = contentProvider.getElements(this.nodeViewer.getInput());
            if (elements != null && elements.length != 0 && (elements[0] instanceof CDOCheckout || elements[0] instanceof CDOResourceNode)) {
                this.node = elements[0];
            }
        }
        if (this.node != null) {
            this.nodeViewer.setSelection((ISelection)new StructuredSelection(this.node), true);
        }
        this.nodeRevealed = true;
    }

    private void fillSegments(List<Object> segments, Object node) {
        if (node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)node;
            Adapter adapter = EcoreUtil.getAdapter((List)folder.eAdapters(), CDOCheckout.class);
            if (adapter != null) {
                this.fillSegments(segments, adapter);
            } else {
                CDOResourceFolder parent = folder.getFolder();
                if (parent == null) {
                    parent = EcoreUtil.getAdapter((List)folder.cdoView().getRootResource().eAdapters(), CDOCheckout.class);
                }
                this.fillSegments(segments, parent);
            }
        }
        segments.add(node);
    }

    private static Object getNode(IStructuredSelection selection) {
        Object element;
        if (selection != null && ((element = selection.getFirstElement()) instanceof CDOCheckout || element instanceof CDOResourceNode)) {
            return element;
        }
        return null;
    }

    protected static boolean isContainer(Object node) {
        return node instanceof CDOCheckout || node instanceof CDOResourceFolder;
    }
}

