/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension3;
import org.eclipse.emf.cdo.spi.server.IAppExtension4;
import org.eclipse.emf.cdo.spi.server.IAppExtension5;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.PluginUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;
import org.xml.sax.SAXException;

public class CDOServerApplication
extends OSGiApplication {
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    public static final String PROP_TITLE = "org.eclipse.emf.cdo.server.title";
    public static final String PROP_CONFIG_FILE_NAME = "org.eclipse.emf.cdo.server.configFileName";
    public static final String PROP_CONFIGURATOR_TYPE = "org.eclipse.emf.cdo.server.repositoryConfiguratorType";
    public static final String PROP_CONFIGURATOR_DESCRIPTION = "org.eclipse.emf.cdo.server.repositoryConfiguratorDescription";
    public static final String PROP_BROWSER_PORT = "org.eclipse.emf.cdo.server.browser.port";
    public static final String PROP_BROWSER_TYPE = "org.eclipse.emf.cdo.server.browser.type";
    private static final OMBundle.TranslationSupport TS = OM.BUNDLE.getTranslationSupport();
    private IRepository[] repositories;
    private List<IAppExtension> earlyExtensions = new ArrayList<IAppExtension>();
    private List<IAppExtension> extensions = new ArrayList<IAppExtension>();

    public CDOServerApplication() {
        super(ID);
    }

    protected String getTitle() {
        return OMPlatform.INSTANCE.getProperty(PROP_TITLE, "CDO server");
    }

    protected File getConfigFile() {
        String configFileName = OMPlatform.INSTANCE.getProperty(PROP_CONFIG_FILE_NAME, "cdo-server.xml");
        return OMPlatform.INSTANCE.getConfigFile(configFileName);
    }

    protected RepositoryConfigurator getConfigurator(IManagedContainer container) {
        String type = OMPlatform.INSTANCE.getProperty(PROP_CONFIGURATOR_TYPE, "default");
        String description = OMPlatform.INSTANCE.getProperty(PROP_CONFIGURATOR_DESCRIPTION);
        return (RepositoryConfigurator)container.getElement("org.eclipse.emf.cdo.server.repositoryConfigurators", type, description);
    }

    protected IManagedContainer getApplicationContainer() {
        return CDOServerApplication.getContainer();
    }

    protected void readExtensions(IManagedContainer container) {
        IConfigurationElement[] elements = PluginUtil.getConfigurationElements((String)"org.eclipse.emf.cdo.server", (String)"appExtensions");
        IConfigurationElement[] iConfigurationElementArray = elements = PluginUtil.removePredecessors((IConfigurationElement[])elements);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("appExtension".equals(element.getName())) {
                try {
                    IAppExtension extension = (IAppExtension)PluginUtil.instantiate((IConfigurationElement)element);
                    if (extension instanceof IManagedContainer.ContainerAware) {
                        ((IManagedContainer.ContainerAware)extension).setManagedContainer(container);
                    }
                    if (extension instanceof IAppExtension5 && ((IAppExtension5)extension).startBeforeRepositories()) {
                        this.earlyExtensions.add(extension);
                    } else {
                        this.extensions.add(extension);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
        this.earlyExtensions.sort(IAppExtension4.COMPARATOR);
        this.extensions.sort(IAppExtension4.COMPARATOR);
    }

    protected void doStart() throws Exception {
        OM.LOG.info(TS.getString("CDOServerApplication.starting", new Object[]{this.getTitle()}));
        super.doStart();
        File configFile = this.getConfigFile();
        if (configFile != null && configFile.exists()) {
            IManagedContainer container = this.getApplicationContainer();
            this.readExtensions(container);
            this.startExtensions(configFile, this.earlyExtensions);
            this.startRepositories(configFile, container);
            this.startBrowser(container);
            this.startExtensions(configFile, this.extensions);
        } else {
            OM.LOG.warn(String.valueOf(TS.getString("CDOServerApplication.noConfig")) + " " + configFile.getAbsolutePath());
        }
        OM.LOG.info(TS.getString("CDOServerApplication.started", new Object[]{this.getTitle()}));
    }

    protected void startRepositories(File configFile, IManagedContainer container) throws ParserConfigurationException, SAXException, IOException, CoreException {
        RepositoryConfigurator repositoryConfigurator = this.getConfigurator(container);
        this.repositories = repositoryConfigurator.configure(configFile);
        if (this.repositories == null || this.repositories.length == 0) {
            OM.LOG.warn(String.valueOf(TS.getString("CDOServerApplication.noRepos")) + " " + configFile.getAbsolutePath());
        }
    }

    protected void startBrowser(IManagedContainer container) {
        String port = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_PORT);
        if (port != null) {
            String type = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_TYPE, "default");
            container.getElement("org.eclipse.emf.cdo.server.browsers", type, port);
        }
    }

    protected void startExtensions(File configFile, List<IAppExtension> extensions) {
        for (IAppExtension extension : extensions) {
            try {
                IAppExtension5 named;
                if (extension instanceof IAppExtension5) {
                    named = (IAppExtension5)extension;
                    OM.LOG.info(TS.getString("AppExtension.starting", new Object[]{named.getName()}));
                }
                if (extension instanceof IAppExtension3) {
                    IAppExtension3 extension3 = (IAppExtension3)extension;
                    extension3.start(this.repositories, configFile);
                } else {
                    extension.start(configFile);
                }
                if (!(extension instanceof IAppExtension5)) continue;
                named = (IAppExtension5)extension;
                OM.LOG.info(TS.getString("AppExtension.started", new Object[]{named.getName()}));
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    protected void doStop() throws Exception {
        OM.LOG.info(TS.getString("CDOServerApplication.stopping", new Object[]{this.getTitle()}));
        this.stopExtensions(this.extensions);
        this.stopRepositories();
        this.stopExtensions(this.earlyExtensions);
        IManagedContainer container = this.getApplicationContainer();
        container.deactivate();
        super.doStop();
        OM.LOG.info(TS.getString("CDOServerApplication.stopped", new Object[]{this.getTitle()}));
    }

    protected void stopExtensions(List<IAppExtension> extensions) {
        Collections.reverse(extensions);
        for (IAppExtension extension : extensions) {
            try {
                IAppExtension5 named;
                if (extension instanceof IAppExtension5) {
                    named = (IAppExtension5)extension;
                    OM.LOG.info(TS.getString("AppExtension.stopping", new Object[]{named.getName()}));
                }
                if (extension instanceof IAppExtension3) {
                    IAppExtension3 extension3 = (IAppExtension3)extension;
                    extension3.stop(this.repositories);
                } else {
                    extension.stop();
                }
                if (!(extension instanceof IAppExtension5)) continue;
                named = (IAppExtension5)extension;
                OM.LOG.info(TS.getString("AppExtension.stopped", new Object[]{named.getName()}));
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    protected void stopRepositories() {
        if (this.repositories != null) {
            IRepository[] iRepositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository repository = iRepositoryArray[n2];
                LifecycleUtil.deactivate((Object)repository);
                ++n2;
            }
        }
    }

    public static IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

