/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PostfixExpression
extends Expression {
    public static final int OP_INC = 0;
    public static final int OP_DEC = 1;
    private final Expression variable;
    private final int operator;

    public PostfixExpression(int start, int end, Expression variable, int operator) {
        super(start, end);
        assert (variable != null);
        this.variable = variable;
        this.operator = operator;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.variable.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public String getOperator() {
        switch (this.getOperatorType()) {
            case 1: {
                return "--";
            }
            case 0: {
                return "++";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getKind() {
        return 44;
    }

    public int getOperatorType() {
        return this.operator;
    }

    public Expression getVariable() {
        return this.variable;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

