/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.php.core.validation.IProblemPreferences;

public class ProblemPreferences
implements IProblemPreferences {
    @Override
    public String getPreferenceQualifier(IProblemIdentifier identifier) {
        return identifier.contributor() + '/' + "pdt_validator" + '/' + identifier.getClass().getName() + '/' + identifier.name();
    }

    @Override
    public IScopeContext[] getScopeContexts(IProject project) {
        if (this.hasProjectSettings(project)) {
            return new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    }

    @Override
    public ProblemSeverity getSeverity(IProblemIdentifier identifier, IScopeContext[] contexts) {
        return ProblemSeverity.valueOf((String)Platform.getPreferencesService().getString(this.getPreferenceQualifier(identifier), "severity", ProblemSeverity.DEFAULT.name(), contexts));
    }

    @Override
    public boolean hasProjectSettings(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.php.core").node("pdt_validator").getBoolean("enabled", false);
    }

    @Override
    public void setSeverity(IProblemIdentifier identifier, ProblemSeverity severity, IScopeContext context) {
        context.getNode(this.getPreferenceQualifier(identifier)).put("severity", severity.name());
    }
}

