/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.refactor.PerformUnsavedRefactoringOperation;
import org.eclipse.wst.xsd.ui.internal.refactor.XMLRefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class UpdateNameCommand
extends BaseCommand {
    private String newName;
    private XSDNamedComponent component;

    public UpdateNameCommand(String label, XSDNamedComponent component, String newName) {
        super(label);
        if (component instanceof XSDComplexTypeDefinition && component.getName() == null && component.eContainer() instanceof XSDNamedComponent && ((XSDNamedComponent)component.eContainer()).getName() != null) {
            component = (XSDNamedComponent)component.eContainer();
        }
        this.component = component;
        this.newName = newName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.component.getElement());
            this.renameComponent(this.newName);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.endRecording();
    }

    private void renameComponent(String newName) {
        if (this.component.eContainer() instanceof XSDSchema) {
            IWorkbenchPage page;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                IEditorInput editorInput = page.getActiveEditor().getEditorInput();
                if (editorInput instanceof FileEditorInput) {
                    XMLRefactoringComponent refactoringComponent = new XMLRefactoringComponent(this.component, (IDOMElement)this.component.getElement(), this.component.getName(), this.component.getTargetNamespace());
                    RenameComponentProcessor processor = new RenameComponentProcessor(refactoringComponent, newName, true);
                    RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
                    PerformUnsavedRefactoringOperation operation = new PerformUnsavedRefactoringOperation((ProcessorBasedRefactoring)refactoring);
                    operation.run(null);
                } else {
                    this.component.setName(newName);
                }
            }
        } else {
            this.component.setName(newName);
        }
    }
}

