/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvertibleMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.EclipseLinkTypeMappingValidator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaEmbeddableImpl;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmMappingConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class EclipseLinkOrmEmbeddableImpl
extends AbstractOrmEmbeddable<XmlEmbeddable>
implements EclipseLinkOrmEmbeddable,
EclipseLinkOrmConverterContainer.Parent {
    protected final EclipseLinkOrmConverterContainer converterContainer = this.buildConverterContainer();
    protected final EclipseLinkOrmChangeTracking changeTracking = this.buildChangeTracking();
    protected final EclipseLinkOrmCustomizer customizer = this.buildCustomizer();

    public EclipseLinkOrmEmbeddableImpl(OrmPersistentType parent, XmlEmbeddable xmlEmbeddable) {
        super(parent, (org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddable)xmlEmbeddable);
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.converterContainer.synchronizeWithResourceModel(monitor);
        this.changeTracking.synchronizeWithResourceModel(monitor);
        this.customizer.synchronizeWithResourceModel(monitor);
    }

    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.converterContainer.update(monitor);
        this.changeTracking.update(monitor);
        this.customizer.update(monitor);
    }

    @Override
    public EclipseLinkOrmConverterContainer getConverterContainer() {
        return this.converterContainer;
    }

    protected EclipseLinkOrmConverterContainer buildConverterContainer() {
        return new EclipseLinkOrmMappingConverterContainer(this, (XmlConverterContainer)this.getXmlTypeMapping());
    }

    @Override
    public int getMaximumAllowedConverters() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterable<EclipseLinkConverter> getConverters() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.converterContainer.getConverters(), this.getAttributeMappingConverters()});
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters() {
        return IterableTools.removeNulls(this.getAttributeMappingConverters_());
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters_() {
        return IterableTools.children((Iterable)this.getAttributeMappings(), EclipseLinkConvertibleMapping.ATTRIBUTE_MAPPING_CONVERTERS_TRANSFORMER);
    }

    @Override
    public EclipseLinkChangeTracking getChangeTracking() {
        return this.changeTracking;
    }

    protected EclipseLinkOrmChangeTracking buildChangeTracking() {
        return new EclipseLinkOrmChangeTracking(this);
    }

    @Override
    public EclipseLinkCustomizer getCustomizer() {
        return this.customizer;
    }

    protected EclipseLinkOrmCustomizer buildCustomizer() {
        return new EclipseLinkOrmCustomizer(this);
    }

    protected String buildSpecifiedParentClass() {
        return ((XmlEmbeddable)this.xmlTypeMapping).getParentClass();
    }

    public void setSpecifiedParentClassInXml(String parentClass) {
        ((XmlEmbeddable)this.xmlTypeMapping).setParentClass(parentClass);
    }

    @Override
    public EclipseLinkJavaEmbeddable getJavaTypeMapping() {
        return (EclipseLinkJavaEmbeddable)super.getJavaTypeMapping();
    }

    @Override
    public EclipseLinkJavaEmbeddable getJavaTypeMappingForDefaults() {
        return (EclipseLinkJavaEmbeddable)super.getJavaTypeMappingForDefaults();
    }

    public EclipseLinkOrmPersistentType getPersistentType() {
        return (EclipseLinkOrmPersistentType)super.getPersistentType();
    }

    @Override
    public boolean usesPrimaryKeyColumns() {
        return false;
    }

    @Override
    public boolean usesPrimaryKeyTenantDiscriminatorColumns() {
        return false;
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createCustomizerRenameTypeEdits(originalType, newName), this.createConverterContainerRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenameTypeEdits(IType originalType, String newName) {
        return this.customizer.createRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createConverterContainerRenameTypeEdits(IType originalType, String newName) {
        return this.converterContainer.createRenameTypeEdits(originalType, newName);
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createCustomizerMoveTypeEdits(originalType, newPackage), this.createConverterContainerMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createCustomizerMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.customizer.createMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createConverterContainerMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.converterContainer.createMoveTypeEdits(originalType, newPackage);
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createCustomizerRenamePackageEdits(originalPackage, newName), this.createConverterContainerRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.customizer.createRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createConverterContainerRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.converterContainer.createRenamePackageEdits(originalPackage, newName);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateParentClass(messages, reporter);
        this.customizer.validate(messages, reporter);
        this.changeTracking.validate(messages, reporter);
        this.converterContainer.validate(messages, reporter);
    }

    protected JpaValidator buildTypeMappingValidator() {
        return new EclipseLinkTypeMappingValidator(this);
    }

    protected void validateParentClass(List<IMessage> messages, IReporter reporter) {
        IType jdtType;
        if (this.specifiedParentClass == null) {
            return;
        }
        if (this.getResolvedParentClass() == null && (jdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedParentClass())) == null) {
            messages.add(this.buildValidationMessage(this.getParentClassTextRange(), JptJpaEclipseLinkCoreValidationMessages.VIRTUAL_TYPE_PARENT_CLASS_DOES_NOT_EXIST, new Object[]{this.getFullyQualifiedParentClass()}));
        }
    }

    protected TextRange getParentClassTextRange() {
        return this.getValidationTextRange(((XmlEmbeddable)this.xmlTypeMapping).getParentClassTextRange());
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.customizer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converterContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (((XmlEmbeddable)this.xmlTypeMapping).parentClassTouches(pos)) {
            return this.getCandidateParentClassNames();
        }
        return null;
    }

    protected Iterable<String> getCandidateParentClassNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getCandidateClassNames(), IterableTools.sort(((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getEclipseLinkDynamicPersistentTypeNames())});
    }

    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return ArrayTools.contains((Object[])EclipseLinkJavaEmbeddableImpl.ALLOWED_ATTRIBUTE_MAPPING_KEYS, (Object)attributeMappingKey);
    }
}

