/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.util.PDEClasspathContainerSaveHelper;

public class ClasspathContainerState {
    private static final UpdateClasspathsJob fUpdateJob = new UpdateClasspathsJob();
    static final IResourceChangeListener CHANGE_LISTENER = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                if (PDECore.DEBUG_STATE) {
                    PDECore.TRACE.trace("/debug/state", String.format("Project %s was deleted.", project.getName()));
                }
                ClasspathContainerState.getStateFile(project).delete();
            }
        }
    };

    private static boolean isUpToDate(IProject project, IClasspathEntry[] currentEntries, IClasspathContainer previousClasspathContainer) {
        if (previousClasspathContainer == null) {
            if (PDECore.DEBUG_STATE) {
                PDECore.TRACE.trace("/debug/state", String.format("%s need update because it has no state to compare", project.getName()));
            }
            return false;
        }
        IClasspathEntry[] previousEntries = previousClasspathContainer.getClasspathEntries();
        if (previousEntries == null || previousEntries.length != currentEntries.length) {
            if (PDECore.DEBUG_STATE) {
                PDECore.TRACE.trace("/debug/state", String.format("%s need update because entries do not match in size!", project.getName()));
            }
            return false;
        }
        int i = 0;
        while (i < previousEntries.length) {
            IClasspathEntry current = currentEntries[i];
            IClasspathEntry previous = previousEntries[i];
            if (!Objects.equals(current, previous)) {
                if (PDECore.DEBUG_STATE) {
                    PDECore.TRACE.trace("/debug/state", String.format("%s need update because entry at position %d is different:\n\t%s\n\t%s", project.getName(), i, current, previous));
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveState(IProject project, IClasspathEntry[] entries) {
        IProject iProject = project;
        synchronized (iProject) {
            block14: {
                try {
                    File stateFile = ClasspathContainerState.getStateFile(project);
                    stateFile.getParentFile().mkdirs();
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(stateFile));){
                        PDEClasspathContainerSaveHelper.writeContainerEntries(entries, stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    if (!PDECore.DEBUG_STATE) break block14;
                    PDECore.TRACE.trace("/debug/state", String.format("Writing project state for %s failed!", project.getName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IClasspathContainer readState(IProject project) {
        IProject iProject = project;
        synchronized (iProject) {
            try {
                File stateFile = ClasspathContainerState.getStateFile(project);
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream stream = new FileInputStream(stateFile);){
                    IClasspathContainer container = Objects.requireNonNull(PDEClasspathContainerSaveHelper.readContainer(stream));
                    if (PDECore.DEBUG_STATE) {
                        PDECore.TRACE.trace("/debug/state", String.format("%s is restored from previous state.", project.getName()));
                    }
                    return container;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (PDECore.DEBUG_STATE) {
                    if (e instanceof FileNotFoundException) {
                        PDECore.TRACE.trace("/debug/state", String.format("%s has no saved state!", project.getName()));
                    } else {
                        PDECore.TRACE.trace("/debug/state", String.format("Restoring project state for %s failed!", project.getName()), (Throwable)e);
                    }
                }
                return PDEClasspathContainerSaveHelper.emptyContainer();
            }
        }
    }

    static void setProjectContainers(IJavaProject[] javaProjects, IClasspathContainer[] container, IProgressMonitor monitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])javaProjects, (IClasspathContainer[])container, (IProgressMonitor)monitor);
    }

    private static File getStateFile(IProject project) {
        return PDECore.getDefault().getStateLocation().append("cpc").append(project.getName()).toFile();
    }

    public static void requestClasspathUpdate(IProject project) {
        if (project == null) {
            return;
        }
        ClasspathContainerState.requestClasspathUpdate(List.of(project));
    }

    public static void requestClasspathUpdate(Collection<IProject> updateProjects) {
        if (updateProjects == null || updateProjects.isEmpty()) {
            return;
        }
        fUpdateJob.addAll(updateProjects);
    }

    static void requestClasspathUpdate(IProject project, IClasspathContainer savedState) {
        fUpdateJob.add(project, savedState);
    }

    private static final class UpdateClasspathsJob
    extends Job {
        private static final int WORK = 10000;
        private final Queue<UpdateRequest> workQueue = new ConcurrentLinkedQueue<UpdateRequest>();

        public UpdateClasspathsJob() {
            super(PDECoreMessages.PluginModelManager_1);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            return family == PluginModelManager.class || family == ClasspathComputer.class;
        }

        protected IStatus run(IProgressMonitor jobMonitor) {
            IStatus[] errors;
            UpdateRequest request;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)jobMonitor, (String)PDECoreMessages.PluginModelManager_1, (int)10000);
            PluginModelManager.getInstance().initialize((IProgressMonitor)monitor.split(10));
            PluginModelManager modelManager = PluginModelManager.getInstance();
            LinkedHashMap<IJavaProject, IClasspathContainer> updateProjects = new LinkedHashMap<IJavaProject, IClasspathContainer>();
            LinkedHashMap<IProject, IStatus> errorsPerProject = new LinkedHashMap<IProject, IStatus>();
            while (!monitor.isCanceled() && (request = this.workQueue.poll()) != null) {
                IPluginModelBase model;
                monitor.setWorkRemaining(10000);
                IProject project = request.project();
                if (!project.exists() || !project.isOpen() || (model = modelManager.findModel(project)) == null || !PluginProject.isJavaProject(project)) continue;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    IClasspathEntry[] entries = ClasspathComputer.computeClasspathEntries(model, javaProject.getProject());
                    if (!ClasspathContainerState.isUpToDate(project, entries, request.container())) {
                        updateProjects.put(javaProject, PDEClasspathContainerSaveHelper.containerOf(entries));
                        errorsPerProject.remove(project);
                        ClasspathContainerState.saveState(project, entries);
                    }
                }
                catch (CoreException e) {
                    errorsPerProject.put(project, e.getStatus());
                }
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (updateProjects.isEmpty()) {
                if (PDECore.DEBUG_STATE) {
                    PDECore.TRACE.trace("/debug/state", "UpdateClasspathsJob finished, but no project needs an update!");
                }
            } else {
                int i = 0;
                int n = updateProjects.size();
                if (PDECore.DEBUG_STATE) {
                    PDECore.TRACE.trace("/debug/state", String.format("UpdateClasspathsJob finished, there are %d project that need a classpath container update.", n));
                }
                IJavaProject[] javaProjects = new IJavaProject[n];
                IClasspathContainer[] container = new IClasspathContainer[n];
                for (Map.Entry entry : updateProjects.entrySet()) {
                    javaProjects[i] = (IJavaProject)entry.getKey();
                    container[i] = (IClasspathContainer)entry.getValue();
                    ++i;
                }
                try {
                    ClasspathContainerState.setProjectContainers(javaProjects, container, (IProgressMonitor)monitor);
                }
                catch (JavaModelException e) {
                    return e.getStatus();
                }
            }
            if ((errors = (IStatus[])errorsPerProject.values().toArray(IStatus[]::new)).length == 0) {
                return Status.OK_STATUS;
            }
            if (errors.length == 1) {
                return errors[0];
            }
            MultiStatus overallStatus = new MultiStatus(ClasspathComputer.class, 0, PDECoreMessages.ClasspathComputer_failed);
            IStatus[] iStatusArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                overallStatus.add(status);
                ++n2;
            }
            return overallStatus;
        }

        void addAll(Collection<IProject> tocheck) {
            for (IProject project : tocheck) {
                this.workQueue.add(new UpdateRequest(project, null));
            }
            this.schedule();
        }

        void add(IProject project, IClasspathContainer classpathContainer) {
            if (project == null) {
                return;
            }
            this.workQueue.add(new UpdateRequest(project, classpathContainer));
            this.schedule();
        }
    }

    private record UpdateRequest(IProject project, IClasspathContainer container) {
    }
}

