/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity;

import org.eclipse.datatools.connectivity.ConnectionProfileConstants;

public class Version
implements Comparable {
    public static final Version NULL_VERSION = new Version(0, 0, 0, new String()){

        @Override
        public String toString() {
            return ConnectionProfileConstants.UNKNOWN_VERSION;
        }
    };
    private Integer mHash;
    private int mMajor;
    private int mMinor;
    private int mRelease;
    private String mBuild;

    public static Version valueOf(String version) {
        if (version == null || version.trim().length() == 0 || version.equals(NULL_VERSION.toString())) {
            return NULL_VERSION;
        }
        int major = 0;
        int minor = 0;
        int release = 0;
        String build = new String();
        String[] components = version.split("\\.", 4);
        if (components[0].trim().length() > 0) {
            try {
                major = Integer.parseInt(components[0].trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (components.length > 1 && components[1].trim().length() > 0) {
            try {
                minor = Integer.parseInt(components[1].trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (components.length > 2 && components[2].trim().length() > 0) {
            try {
                release = Integer.parseInt(components[2].trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (components.length > 3 && components[3].trim().length() > 0) {
            build = components[3].trim();
        }
        return new Version(major, minor, release, build);
    }

    public Version(int major, int minor, int release, String build) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mRelease = release;
        this.mBuild = build;
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public int getRelease() {
        return this.mRelease;
    }

    public String getBuild() {
        return this.mBuild;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        int retVal = this.mMajor != v.mMajor ? this.mMajor - v.mMajor : (this.mMinor != v.mMinor ? this.mMinor - v.mMinor : (this.mRelease != v.mRelease ? this.mRelease - v.mRelease : this.mBuild.compareTo(v.mBuild)));
        if (retVal == 0) {
            if (v == NULL_VERSION) {
                if (this != NULL_VERSION) {
                    retVal = 1;
                }
            } else if (this == NULL_VERSION) {
                retVal = -1;
            }
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        boolean retVal = obj instanceof Version ? this.compareTo(obj) == 0 : false;
        return retVal;
    }

    public int hashCode() {
        if (this.mHash == null) {
            this.mHash = this.toString().hashCode();
        }
        return this.mHash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getMajor());
        buf.append('.').append(this.getMinor());
        buf.append('.').append(this.getRelease());
        if (this.getBuild() != null && this.getBuild().length() > 0) {
            buf.append('.').append(this.getBuild());
        }
        return buf.toString();
    }
}

