/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.net.URI;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.MethodSource;

class MethodSourceSupport {
    static final String METHOD_SCHEME = "method";

    static MethodSource from(URI uri) {
        Preconditions.notNull((Object)uri, (String)"URI must not be null");
        Preconditions.condition((boolean)METHOD_SCHEME.equals(uri.getScheme()), () -> "URI [" + String.valueOf(uri) + "] must have [method] scheme");
        String schemeSpecificPart = (String)Preconditions.notNull((Object)uri.getSchemeSpecificPart(), () -> "Invalid method URI (scheme-specific part must not be null). Please consult the Javadoc of " + DiscoverySelectors.class.getName() + "#selectMethod(String) for details on the supported formats.");
        String fragment = (String)Preconditions.notNull((Object)uri.getFragment(), () -> "Invalid method URI (fragment must not be null). Please consult the Javadoc of " + DiscoverySelectors.class.getName() + "#selectMethod(String) for details on the supported formats.");
        String fullyQualifiedMethodName = schemeSpecificPart + "#" + fragment;
        String[] methodSpec = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        return MethodSource.from((String)methodSpec[0], (String)methodSpec[1], (String)methodSpec[2]);
    }

    private MethodSourceSupport() {
    }
}

