/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSI1109
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1109(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        block8: {
            if (entryContext.getMessageEntry() != null && !this.validator.isOneWayResponse(entryContext)) {
                try {
                    NodeList claimList;
                    Document doc = entryContext.getMessageEntryDocument();
                    Element root = doc.getDocumentElement();
                    NodeList headerList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                    Element headerElem = null;
                    if (headerList != null && headerList.getLength() != 0) {
                        headerElem = (Element)headerList.item(0);
                    }
                    if ((claimList = root.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim")) == null || claimList.getLength() == 0) {
                        this.result = "notApplicable";
                        break block8;
                    }
                    int i = 0;
                    while (i < claimList.getLength()) {
                        if (headerElem == null || claimList.item(i).getParentNode() != headerElem) {
                            this.result = "failed";
                            this.failureDetail = this.validator.createFailureDetail("\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    this.result = "notApplicable";
                }
            } else {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

