/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.java.ecj.JavaEnvironmentWithEcjBuilder;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;

public final class JavaEnvironmentFactories {
    private JavaEnvironmentFactories() {
    }

    public static final class RunningJavaEnvironmentFactory
    implements IJavaEnvironmentFactory {
        @Override
        public JavaEnvironmentWithEcjBuilder<?> get() {
            return new JavaEnvironmentWithEcjBuilder().withoutScoutSdk();
        }
    }

    public static final class EmptyJavaEnvironmentFactory
    implements IJavaEnvironmentFactory {
        @Override
        public JavaEnvironmentWithEcjBuilder<?> get() {
            return ((JavaEnvironmentWithEcjBuilder)new JavaEnvironmentWithEcjBuilder().withoutScoutSdk()).withRunningClasspath(false);
        }
    }

    @FunctionalInterface
    public static interface IJavaEnvironmentFactory
    extends Supplier<JavaEnvironmentWithEcjBuilder<?>> {
        default public <T> T call(Function<IJavaEnvironment, T> task) {
            return ((JavaEnvironmentWithEcjBuilder)this.get()).call(task);
        }

        default public void accept(Consumer<IJavaEnvironment> task) {
            ((JavaEnvironmentWithEcjBuilder)this.get()).accept(task);
        }
    }
}

