/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.scout.sdk.core.typescript.builder.imports.ES6ImportCollector;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.IPackageJson;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeElementSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractNodeElement<SPI extends NodeElementSpi>
implements INodeElement {
    private final SPI m_spi;
    private final FinalValue<Optional<String>> m_containingFileName;
    private final FinalValue<Optional<SourceRange>> m_source;

    protected AbstractNodeElement(SPI spi) {
        this.m_spi = (NodeElementSpi)Ensure.notNull(spi);
        this.m_containingFileName = new FinalValue();
        this.m_source = new FinalValue();
    }

    public SPI spi() {
        return this.m_spi;
    }

    @Override
    public INodeModule containingModule() {
        return this.spi().containingModule().api();
    }

    @Override
    public Optional<Path> containingFile() {
        return this.spi().containingFile();
    }

    @Override
    public Optional<String> containingFileName() {
        return (Optional)this.m_containingFileName.computeIfAbsentAndGet(() -> this.containingFile().map(Path::getFileName).map(Path::toString));
    }

    @Override
    public boolean isTypeScript() {
        return this.containingFileName().map(fileName -> Strings.endsWith((CharSequence)fileName, (CharSequence)".ts", (boolean)false)).orElse(false);
    }

    @Override
    public INodeElement.ExportType exportType() {
        return this.spi().exportType();
    }

    @Override
    public Optional<String> computeImportPathFrom(INodeElement fromElement) {
        return Optional.ofNullable(fromElement).flatMap(f -> this.computeImportPathFrom(f.containingModule(), f.containingFile().orElse(null)));
    }

    @Override
    public Optional<String> computeImportPathFrom(INodeModule fromModule, Path fromFile) {
        Path importTarget;
        if (this.containingModule() != fromModule) {
            return Optional.ofNullable(this.containingModule().name());
        }
        if (fromFile == null) {
            return Optional.empty();
        }
        if (this.isExportedFromModule()) {
            IPackageJson packageJson = this.containingModule().packageJson();
            importTarget = packageJson.mainLocation().orElse(packageJson.location());
        } else {
            importTarget = this.containingFile().orElse(null);
        }
        if (importTarget == null) {
            return Optional.empty();
        }
        return Optional.of(ES6ImportCollector.buildRelativeImportPath(fromFile, importTarget));
    }

    @Override
    public Set<String> moduleExportNames() {
        Set<String> exportNames = this.containingModule().spi().elements().get(this.spi());
        if (exportNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(exportNames);
    }

    @Override
    public boolean isExportedFromModule() {
        return !this.moduleExportNames().isEmpty();
    }

    @Override
    public Optional<SourceRange> source() {
        return (Optional)this.m_source.computeIfAbsentAndGet(() -> this.spi().source());
    }
}

