/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.directedit;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;

public class DirectEditSelectionTool
extends SelectionTool {
    protected INamedEditPart getSelectedPart() {
        if (this.getCurrentViewer() == null) {
            return null;
        }
        EditPart ep = this.getCurrentViewer().getFocusEditPart();
        if (ep instanceof INamedEditPart && ep.isActive()) {
            return (INamedEditPart)ep;
        }
        return null;
    }

    protected boolean handleButtonDown(int button) {
        super.handleButtonDown(button);
        INamedEditPart selectedPart = this.getSelectedPart();
        if (selectedPart != null && button == 1) {
            AbstractTool.Input i = this.getCurrentInput();
            Point l = this.translateLocation(i.getMouseLocation());
            IFigure f = ((AbstractGraphicalEditPart)selectedPart).getFigure();
            Rectangle bounds = f.getBounds();
            if (bounds.contains(l.x, l.y)) {
                selectedPart.performDirectEdit(this.translateLocation(new Point(l.x, l.y)));
                return true;
            }
        }
        return true;
    }

    protected Point translateLocation(Point mouseLocation) {
        FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
        Point viewLocation = canvas.getViewport().getViewLocation();
        return new Point(mouseLocation.x + viewLocation.x, mouseLocation.y + viewLocation.y);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        boolean result = super.handleKeyUp(e);
        EditPartViewer currentViewer = this.getCurrentViewer();
        if ((e.keyCode == 13 || e.keyCode == 0x1000050) && currentViewer != null) {
            EditPart editPart = currentViewer.getFocusEditPart();
            if (editPart == null) {
                return result;
            }
            SelectionRequest request = new SelectionRequest();
            request.setLocation(this.getLocation());
            request.setType((Object)"open");
            editPart.performRequest((Request)request);
            return true;
        }
        return result;
    }
}

