/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.beans.Beans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class InputHistory {
    protected static final int MAX_HISTORY = 10;
    protected IDialogSettings dialogSettings;
    private final Map<String, List<ControlWrapper>> comboMap = new HashMap<String, List<ControlWrapper>>();
    private final List<String> privileged;

    public InputHistory(String sectionName) {
        this(sectionName, new String[0]);
    }

    public InputHistory(String sectionName, String[] privileged) {
        M2EUIPluginActivator plugin = M2EUIPluginActivator.getDefault();
        if (plugin != null) {
            IDialogSettings pluginSettings = plugin.getDialogSettings();
            this.dialogSettings = pluginSettings.getSection(sectionName);
            if (this.dialogSettings == null) {
                this.dialogSettings = pluginSettings.addNewSection(sectionName);
                pluginSettings.addSection(this.dialogSettings);
            }
        }
        assert (privileged != null);
        this.privileged = Arrays.asList(privileged);
    }

    public void load() {
        if (Beans.isDesignTime()) {
            return;
        }
        for (Map.Entry<String, List<ControlWrapper>> e : this.comboMap.entrySet()) {
            String id = e.getKey();
            LinkedHashSet<String> items = new LinkedHashSet<String>();
            String[] itemsArr = this.dialogSettings.getArray(id);
            items.addAll(this.privileged);
            if (itemsArr != null) {
                items.addAll(Arrays.asList(itemsArr));
            }
            for (ControlWrapper wrapper : e.getValue()) {
                if (wrapper.isDisposed()) continue;
                wrapper.setItems(items.toArray(new String[0]));
            }
        }
    }

    public void save() {
        if (Beans.isDesignTime()) {
            return;
        }
        for (Map.Entry<String, List<ControlWrapper>> e : this.comboMap.entrySet()) {
            ControlWrapper wrapper2;
            String id = e.getKey();
            LinkedHashSet<String> history = new LinkedHashSet<String>(10);
            for (ControlWrapper wrapper2 : e.getValue()) {
                wrapper2.collect();
                String lastValue = wrapper2.text;
                if (lastValue == null || lastValue.trim().length() <= 0) continue;
                history.add(lastValue);
            }
            wrapper2 = e.getValue().iterator().next();
            String[] items = wrapper2.items;
            if (items != null) {
                int j = 0;
                while (j < items.length && history.size() < 10) {
                    if (!this.privileged.contains(items[j])) {
                        history.add(items[j]);
                    }
                    ++j;
                }
            }
            this.dialogSettings.put(id, history.toArray(new String[history.size()]));
        }
    }

    public void add(Control combo) {
        this.add(null, combo);
    }

    public void add(String id, Control combo) {
        if (combo != null) {
            List<ControlWrapper> combos;
            if (id == null) {
                id = String.valueOf(combo.getData("name"));
            }
            if ((combos = this.comboMap.get(id)) == null) {
                combos = new ArrayList<ControlWrapper>();
                this.comboMap.put(id, combos);
            }
            if (combo instanceof Combo) {
                Combo regularCombo = (Combo)combo;
                combos.add(new ComboWrapper(regularCombo));
            } else if (combo instanceof CCombo) {
                CCombo ccombo = (CCombo)combo;
                combos.add(new CComboWrapper(ccombo));
            }
        }
    }

    private class CComboWrapper
    extends ControlWrapper {
        private final CCombo combo;

        protected CComboWrapper(CCombo combo) {
            super((Control)combo);
            this.combo = combo;
        }

        @Override
        protected String getText() {
            return this.combo.getText();
        }

        @Override
        protected String[] getItems() {
            try {
                return this.combo.getItems();
            }
            catch (SWTException swtException) {
                return new String[0];
            }
        }

        @Override
        protected void setItems(String[] items) {
            String value = this.combo.getText();
            this.combo.setItems(items);
            if (value.length() > 0) {
                this.combo.setText(value);
            }
        }
    }

    private class ComboWrapper
    extends ControlWrapper {
        private final Combo combo;

        protected ComboWrapper(Combo combo) {
            super((Control)combo);
            this.combo = combo;
        }

        @Override
        protected String getText() {
            return this.combo.getText();
        }

        @Override
        protected String[] getItems() {
            return this.combo.getItems();
        }

        @Override
        protected void setItems(String[] items) {
            String value = this.combo.getText();
            this.combo.setItems(items);
            if (value.length() > 0) {
                this.combo.setText(value);
            } else if (items.length > 0) {
                this.combo.setText(items[0]);
            }
        }
    }

    private abstract class ControlWrapper {
        protected Control control;
        protected String text;
        protected String[] items;
        private boolean collected;

        protected ControlWrapper(Control control) {
            this.control = control;
            control.addDisposeListener(e -> this.collect());
        }

        protected void collect() {
            if (!this.collected && !this.isDisposed()) {
                this.text = this.getText();
                this.items = this.getItems();
            }
            this.collected = true;
        }

        protected boolean isDisposed() {
            return this.control.isDisposed();
        }

        protected abstract String getText();

        protected abstract String[] getItems();

        protected abstract void setItems(String[] var1);
    }
}

