/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientFactory;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpServiceContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.NTLMDomainUtil;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="org.eclipse.epp.mpc.core.http.client", service={HttpClientService.class})
public class HttpClientService {
    private CloseableHttpClient client;
    private HttpServiceContext context;
    private volatile IProxyService proxyService;

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, updated="bindClientFactory", unbind="unbindClientFactory")
    void bindClientFactory(HttpClientFactory factory) {
        this.context = factory.build(this.context);
        this.client = this.context.getClient();
    }

    void unbindClientFactory(HttpClientFactory factory) {
    }

    @Reference(field="proxyService", unbind="unbindProxyService", policy=ReferencePolicy.DYNAMIC)
    void bindProxyService(IProxyService proxyService) {
        this.proxyService = proxyService;
    }

    void unbindProxyService(IProxyService proxyService) {
        if (this.proxyService == proxyService) {
            this.proxyService = null;
        }
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request) throws ClientProtocolException, IOException {
        return this.execute(request, null);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpContext context) throws ClientProtocolException, IOException {
        HttpClientContext internalContext = context == null ? new HttpClientContext() : HttpClientContext.adapt((HttpContext)context);
        ClassicHttpRequest configuredRequest = this.configureRequestExecution(request, internalContext);
        return this.client.execute(configuredRequest, (HttpContext)internalContext);
    }

    private ClassicHttpRequest configureRequestExecution(ClassicHttpRequest request, HttpClientContext context) throws IOException {
        RequestConfig requestConfig = context.getRequestConfig();
        RequestConfig.Builder builder = requestConfig != null ? RequestConfig.copy((RequestConfig)requestConfig) : (request instanceof Configurable && ((Configurable)request).getConfig() != null ? RequestConfig.copy((RequestConfig)((Configurable)request).getConfig()) : (this.client instanceof Configurable && ((Configurable)this.client).getConfig() != null ? RequestConfig.copy((RequestConfig)((Configurable)this.client).getConfig()) : RequestConfig.custom()));
        this.configureRequestExecution(request, context, builder);
        RequestConfig config = builder.build();
        return HttpClientService.setConfig(request, config);
    }

    protected void configureRequestExecution(ClassicHttpRequest request, HttpClientContext context, RequestConfig.Builder builder) throws IOException {
        try {
            this.configureProxy(request.getUri(), context, builder);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static ClassicHttpRequest setConfig(ClassicHttpRequest request, RequestConfig config) {
        if (request instanceof HttpUriRequestBase) {
            ((HttpUriRequestBase)request).setConfig(config);
        } else {
            request = ClassicRequestBuilder.copy((ClassicHttpRequest)request).build();
        }
        return request;
    }

    public ClassicHttpRequest configureRequest(ClassicHttpRequest request) {
        if (this.client instanceof Configurable && ((Configurable)this.client).getConfig() != null) {
            return HttpClientService.setConfig(request, ((Configurable)this.client).getConfig());
        }
        return request;
    }

    public HttpResponse configureAndExecute(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.configureAndExecute(request, null);
    }

    public HttpResponse configureAndExecute(HttpUriRequest request, HttpContext context) throws ClientProtocolException, IOException {
        return this.execute(this.configureRequest((ClassicHttpRequest)request), context);
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public IProxyService getProxyService() {
        return this.proxyService;
    }

    private IProxyData getProxyData(URI uri) {
        return this.proxyService == null ? null : ProxyHelper.getProxyData(uri, this.proxyService);
    }

    private HttpHost getProxyHost(IProxyData proxy) {
        if ("HTTPS".equals(proxy.getType()) || "HTTP".equals(proxy.getType())) {
            return new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return null;
    }

    private void configureProxy(URI uri, HttpClientContext context, RequestConfig.Builder builder) throws IOException {
        IProxyData proxy = this.getProxyData(uri);
        if (proxy != null) {
            builder.setProxy(this.getProxyHost(proxy));
            this.setProxyAuthentication(context, proxy);
        } else {
            builder.setProxy(null);
        }
    }

    private void setProxyAuthentication(HttpClientContext context, IProxyData proxy) throws IOException {
        HttpHost proxyHost;
        String proxyUserID = proxy.getUserId();
        if (proxyUserID != null && (proxyHost = this.getProxyHost(proxy)) != null) {
            String domainUserID = NTLMDomainUtil.getNTLMUserName(proxyUserID);
            char[] password = proxy.getPassword().toCharArray();
            String domain = NTLMDomainUtil.getNTLMUserDomain(proxyUserID);
            if (domain != null || !proxyUserID.equals(domainUserID)) {
                String workstation = NTLMDomainUtil.getNTLMWorkstation();
                this.setAuth(context, new AuthScope(proxyHost, null, "NTLM"), (Credentials)new NTCredentials(domainUserID, password, workstation, domain));
            } else {
                this.setAuth(context, new AuthScope(proxyHost, null, null), (Credentials)new UsernamePasswordCredentials(proxyUserID, password));
            }
        }
    }

    private void setAuth(HttpClientContext clientContext, AuthScope authScope, Credentials credentials) {
        CredentialsStore authStore = (CredentialsStore)clientContext.getCredentialsProvider();
        if (authStore == null) {
            authStore = new BasicCredentialsProvider();
            authStore = new ChainedCredentialsProvider(authStore, this.context.getCredentialsProvider());
            clientContext.setCredentialsProvider((CredentialsProvider)authStore);
        }
        authStore.setCredentials(authScope, credentials);
    }
}

