/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.selection;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public final class SelectionUtils {
    private SelectionUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static void selectAndReveal(List<? extends IResource> resources, IWorkbenchWindow window) {
        IWorkbenchPart part;
        if (window == null || resources == null || resources.isEmpty()) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList parts = Lists.newArrayList();
        for (IViewReference iViewReference : page.getViewReferences()) {
            part = iViewReference.getPart(false);
            if (part == null) continue;
            parts.add(part);
        }
        for (IViewReference iViewReference : page.getEditorReferences()) {
            part = iViewReference.getPart(false);
            if (part == null) continue;
            parts.add(part);
        }
        StructuredSelection selection = new StructuredSelection(resources);
        for (IWorkbenchPart part2 : parts) {
            void var7_15;
            if (part2 instanceof ISetSelectionTarget) {
                ISetSelectionTarget iSetSelectionTarget = (ISetSelectionTarget)part2;
            } else {
                ISetSelectionTarget iSetSelectionTarget = (ISetSelectionTarget)part2.getAdapter(ISetSelectionTarget.class);
            }
            if (var7_15 == null) continue;
            void finalTarget = var7_15;
            window.getShell().getDisplay().asyncExec(new Runnable(){
                final /* synthetic */ ISetSelectionTarget val$finalTarget;
                final /* synthetic */ ISelection val$selection;
                {
                    this.val$finalTarget = iSetSelectionTarget;
                    this.val$selection = iSelection;
                }

                @Override
                public void run() {
                    this.val$finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public static boolean belongsToViewPart(IWorkbenchPartReference partReference, IViewPart viewPart) {
        if (partReference instanceof IViewReference) {
            IViewReference currentReference = (IViewReference)partReference;
            IViewSite viewSite = viewPart.getViewSite();
            if (viewSite != null && currentReference.getId().equals(viewSite.getId()) && Objects.equal((Object)currentReference.getSecondaryId(), (Object)viewSite.getSecondaryId())) {
                return true;
            }
        }
        return false;
    }
}

