/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.tasks.core.ITask;

public class TransferList
implements ITransferList {
    private final Set<RepositoryQuery> queries;
    private final List<AbstractTask> tasks;
    private final Set<AbstractTaskCategory> categories;

    public TransferList() {
        this.queries = new HashSet<RepositoryQuery>();
        this.tasks = new ArrayList<AbstractTask>();
        this.categories = new HashSet<AbstractTaskCategory>();
    }

    public TransferList(Set<AbstractTaskCategory> categories, Set<RepositoryQuery> queries, List<AbstractTask> tasks) {
        this.tasks = new ArrayList<AbstractTask>(tasks);
        this.queries = new HashSet<RepositoryQuery>(queries);
        this.categories = new HashSet<AbstractTaskCategory>(categories);
    }

    @Override
    public void addCategory(TaskCategory category) {
        this.categories.add(category);
    }

    @Override
    public void addQuery(RepositoryQuery query) {
        this.queries.add(query);
    }

    @Override
    public void addTask(ITask task) {
        this.tasks.add((AbstractTask)task);
    }

    @Override
    public boolean addTask(ITask task, AbstractTaskContainer parentContainer) {
        if (!this.tasks.contains(task)) {
            this.tasks.add((AbstractTask)task);
        }
        parentContainer.internalAddChild((AbstractTask)task);
        return true;
    }

    @Override
    public Collection<AbstractTask> getAllTasks() {
        return this.tasks;
    }

    @Override
    public Set<AbstractTaskCategory> getCategories() {
        return this.categories;
    }

    @Override
    public AbstractTaskCategory getContainerForHandle(String handle) {
        Assert.isNotNull((Object)handle);
        for (AbstractTaskCategory category : this.categories) {
            if (!category.getHandleIdentifier().equals(handle)) continue;
            return category;
        }
        return null;
    }

    @Override
    public Set<RepositoryQuery> getQueries() {
        return this.queries;
    }

    @Override
    public AbstractTask getTask(String handleIdentifier) {
        Assert.isNotNull((Object)handleIdentifier);
        for (AbstractTask task : this.tasks) {
            if (!task.getHandleIdentifier().equals(handleIdentifier)) continue;
            return task;
        }
        return null;
    }

    @Override
    public ITask getTask(String repositoryUrl, String taskId) {
        Assert.isNotNull((Object)repositoryUrl);
        Assert.isNotNull((Object)taskId);
        for (AbstractTask task : this.tasks) {
            if (!task.getRepositoryUrl().equals(repositoryUrl) || !task.getTaskId().equals(taskId)) continue;
            return task;
        }
        return null;
    }
}

