/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.MavenLaunchExtensionsSupport;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.m2e.jdt.MavenExecutionJre;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchDelegate
extends JavaLaunchDelegate
implements MavenLaunchConstants {
    private static final Logger log;
    private static final String LAUNCHER_TYPE = "org.codehaus.classworlds.Launcher";
    private static final String LAUNCHER_TYPE3 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String ANSI_SUPPORT_QUALIFIER = "org.eclipse.ui.console";
    private static final String ANSI_SUPPORT_KEY = "ANSI_support_enabled";
    private static final VersionRange MAVEN_33PLUS_RUNTIMES;
    private ILaunch launch;
    private IProgressMonitor monitor;
    private String programArguments;
    private MavenRuntimeLaunchSupport launchSupport;
    private MavenLaunchExtensionsSupport extensionsSupport;
    private IPreferencesService preferencesService;

    static {
        VersionRange mvn33PlusRange;
        log = LoggerFactory.getLogger(MavenLaunchDelegate.class);
        try {
            mvn33PlusRange = VersionRange.createFromVersionSpec((String)"[3.3,)");
        }
        catch (InvalidVersionSpecificationException O_o) {
            mvn33PlusRange = null;
        }
        MAVEN_33PLUS_RUNTIMES = mvn33PlusRange;
    }

    public MavenLaunchDelegate() {
        this.allowAdvancedSourcelookup();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.monitor = monitor;
        this.programArguments = null;
        try {
            this.launchSupport = MavenRuntimeLaunchSupport.create(configuration, monitor);
            this.extensionsSupport = MavenLaunchExtensionsSupport.create(configuration, launch);
            this.preferencesService = Platform.getPreferencesService();
            log.info("Run build in \"{}\":", (Object)this.getWorkingDirectory(configuration));
            log.info(" mvn {}", (Object)this.getProgramArguments(configuration));
            this.extensionsSupport.configureSourceLookup(configuration, launch, monitor);
            super.launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launch = null;
            this.monitor = null;
            this.launchSupport = null;
            this.extensionsSupport = null;
            this.preferencesService = null;
        }
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("M2_SAVE_BEFORE_LAUNCH", true)) {
            return super.saveBeforeLaunch(configuration, mode, monitor);
        }
        return true;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.launchSupport.decorateVMRunner(super.getVMRunner(configuration, mode));
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return this.launchSupport.getVersion().startsWith("3.") ? LAUNCHER_TYPE3 : LAUNCHER_TYPE;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) {
        List<String> cp = this.launchSupport.getBootClasspath();
        return (String[])cp.toArray(String[]::new);
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) {
        String[][] paths = new String[2][];
        paths[0] = this.getClasspath(configuration);
        return paths;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        if (this.programArguments == null) {
            String goals = this.getGoals(configuration);
            StringBuilder sb = new StringBuilder();
            this.getProperties(sb, configuration);
            this.getPreferences(sb, configuration, goals);
            sb.append(" ").append(goals);
            this.extensionsSupport.appendProgramArguments(sb, configuration, this.launch, this.monitor);
            this.programArguments = sb.toString();
        }
        return this.programArguments;
    }

    public static File getPomDirectory(ILaunchConfiguration configuration) {
        String pomDir;
        if (configuration == null) {
            return null;
        }
        try {
            pomDir = configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, "");
        }
        catch (CoreException ex) {
            log.warn("Failed to retrieve attribute '{}' from launch configuration {}", (Object)MavenLaunchConstants.ATTR_POM_DIR, (Object)configuration.getName());
            return null;
        }
        try {
            return new File(LaunchingUtils.substituteVar(pomDir));
        }
        catch (CoreException e) {
            log.debug("Cannot substitute vars in {}", (Object)pomDir, (Object)e);
            return null;
        }
    }

    public static Optional<IContainer> getContainer(File file) {
        return Optional.ofNullable(file).map(f -> IPath.fromOSString((String)f.toString())).map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getContainerForLocation(arg_0));
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        Optional<IProject> project;
        Optional<IMavenProjectFacade> mavenProject;
        File pomDirectory = MavenLaunchDelegate.getPomDirectory(configuration);
        if (!configuration.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH) && (mavenProject = MavenLaunchDelegate.getMavenProject(pomDirectory, this.monitor)).isPresent()) {
            log.debug("Looking for enforced JRE for Maven project {}", (Object)mavenProject.get().getProject().getName());
            Optional jre = MavenExecutionJre.forProject((IMavenProjectFacade)mavenProject.get(), (IProgressMonitor)this.monitor).flatMap(MavenExecutionJre::getBestMatchingVM);
            if (jre.isPresent()) {
                log.info("Run with Maven execution JRE: {}", jre.get());
                return (IVMInstall)jre.get();
            }
        }
        if ((project = MavenLaunchDelegate.getContainer(pomDirectory).map(IResource::getProject).filter(p -> JavaCore.create((IProject)p).exists())).isPresent()) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.get().getName());
            configuration = workingCopy;
        }
        return super.getVMInstall(configuration);
    }

    public static Optional<IMavenProjectFacade> getMavenProject(File pomDirectory, IProgressMonitor monitor) {
        Optional<IContainer> container = MavenLaunchDelegate.getContainer(pomDirectory);
        if (container.isPresent()) {
            IPath pomPath = IPath.fromOSString((String)"pom.xml");
            if (container.get().exists(pomPath)) {
                IFile pomFile = container.get().getFile(pomPath);
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                return Optional.of(projectManager.create(pomFile, true, monitor));
            }
        }
        return Optional.empty();
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        MavenRuntimeLaunchSupport.VMArguments arguments = this.launchSupport.getVMArguments();
        AbstractMavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        this.appendRuntimeSpecificArguments(runtime.getVersion(), arguments, configuration);
        this.extensionsSupport.appendVMArguments(arguments, configuration, this.launch, this.monitor);
        arguments.append(super.getVMArguments(configuration));
        return arguments.toString();
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_GOALS", "");
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return false;
    }

    private void getProperties(StringBuilder sb, ILaunchConfiguration configuration) throws CoreException {
        List properties;
        try {
            properties = configuration.getAttribute("M2_PROPERTIES", Collections.emptyList());
        }
        catch (CoreException e) {
            log.error("Exception while getting configuration attribute M2_PROPERTIES", (Throwable)e);
            throw e;
        }
        for (String property : properties) {
            int n = property.indexOf(61);
            String name = property;
            String value = null;
            if (n > -1) {
                name = property.substring(0, n);
                if (n > 1) {
                    String substring = property.substring(n + 1);
                    try {
                        value = LaunchingUtils.substituteVar(substring);
                    }
                    catch (CoreException e) {
                        log.debug("Exception while substitute variables in substring " + substring + " using raw value.", (Throwable)e);
                        value = substring;
                    }
                }
            }
            sb.append(" -D").append(name);
            if (value == null) continue;
            sb.append('=').append(MavenLaunchUtils.quote(value));
        }
        try {
            String profiles = configuration.getAttribute("M2_PROFILES", null);
            if (profiles != null && profiles.trim().length() > 0) {
                sb.append(" -P").append(profiles.replaceAll("\\s+", ","));
            }
        }
        catch (CoreException ex) {
            log.error("Exception while getting configuration attribute M2_PROFILES", (Throwable)ex);
            throw ex;
        }
    }

    private void getPreferences(StringBuilder sb, ILaunchConfiguration configuration, String goals) throws CoreException {
        int colors;
        int threads;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        if (configuration.getAttribute("M2_BATCH", true)) {
            sb.append(" -B");
        }
        if (configuration.getAttribute("M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput())) {
            sb.append(" -X").append(" -e");
        }
        if (configuration.getAttribute("M2_OFFLINE", mavenConfiguration.isOffline())) {
            sb.append(" -o");
        }
        if (configuration.getAttribute("M2_UPDATE_SNAPSHOTS", false)) {
            sb.append(" -U");
        }
        if (configuration.getAttribute("M2_NON_RECURSIVE", false)) {
            sb.append(" -N");
        }
        if (configuration.getAttribute("M2_SKIP_TESTS", false)) {
            sb.append(" -Dmaven.test.skip=true -DskipTests");
        }
        if ((threads = configuration.getAttribute("M2_THREADS", 1)) > 1) {
            sb.append(" --threads ").append(threads);
        }
        if ((colors = configuration.getAttribute("M2_COLORS", 0)) == 0) {
            colors = this.isAnsiProcessingEnabled() ? 1 : 2;
        }
        String enableColor = switch (colors) {
            case 1 -> "always";
            case 2 -> "never";
            default -> throw new IllegalArgumentException("Unexpected value forM2_COLORS: " + colors);
        };
        sb.append(" -Dstyle.color=" + enableColor);
        if (!goals.contains("-gs ")) {
            String globalSettings = this.launchSupport.getSettings();
            if (globalSettings != null && !globalSettings.trim().isEmpty() && !new File(globalSettings.trim()).exists()) {
                globalSettings = null;
            }
            if (globalSettings != null && !globalSettings.trim().isEmpty()) {
                sb.append(" -gs ").append(MavenLaunchUtils.quote(globalSettings));
            }
        }
        String settings = configuration.getAttribute("M2_USER_SETTINGS", null);
        if (!((settings = LaunchingUtils.substituteVar(settings)) != null && !settings.trim().isEmpty() || (settings = mavenConfiguration.getUserSettingsFile()) == null || settings.trim().isEmpty() || new File(settings.trim()).exists())) {
            settings = null;
        }
        if (settings != null && !settings.trim().isEmpty()) {
            sb.append(" -s ").append(MavenLaunchUtils.quote(settings));
        }
    }

    private boolean isAnsiProcessingEnabled() {
        return this.preferencesService.getBoolean(ANSI_SUPPORT_QUALIFIER, ANSI_SUPPORT_KEY, true, null);
    }

    public void appendRuntimeSpecificArguments(String runtimeVersion, MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        if (this.applies(runtimeVersion)) {
            this.getArgsFromMvnDir(arguments, configuration);
        }
    }

    private void getArgsFromMvnDir(MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        String pomDir = LaunchingUtils.substituteVar(configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, ""));
        if (pomDir.isEmpty()) {
            return;
        }
        File baseDir = this.findMavenProjectBasedir(new File(pomDir));
        File mvnDir = new File(baseDir, ".mvn");
        File jvmConfig = new File(mvnDir, "jvm.config");
        if (jvmConfig.isFile()) {
            try {
                for (String line : Files.readAllLines(jvmConfig.toPath(), StandardCharsets.UTF_8)) {
                    arguments.append(line);
                }
            }
            catch (IOException ex) {
                String msg = NLS.bind((String)Messages.MavenLaunchDelegate_error_cannot_read_jvmConfig, (Object)jvmConfig.getAbsolutePath());
                throw new CoreException(Status.error((String)msg, (Throwable)ex));
            }
        }
        arguments.appendProperty("maven.multiModuleProjectDirectory", MavenLaunchUtils.quote(baseDir.getAbsolutePath()));
    }

    private File findMavenProjectBasedir(File dir) {
        File folder = dir;
        while (folder != null && folder.getParentFile() != null) {
            if (new File(folder, ".mvn").isDirectory()) {
                return folder;
            }
            folder = folder.getParentFile();
        }
        return dir;
    }

    private boolean applies(String runtimeVersion) {
        return MAVEN_33PLUS_RUNTIMES.containsVersion((ArtifactVersion)new DefaultArtifactVersion(runtimeVersion));
    }
}

