/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.MavenArtifactComponent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenInstallFileArtifactWizardPage
extends WizardPage {
    private static final Logger log = LoggerFactory.getLogger(MavenInstallFileArtifactWizardPage.class);
    Text artifactFileNameText;
    Text pomFileNameText;
    private Combo groupIdCombo;
    private Combo artifactIdCombo;
    private Combo versionCombo;
    private Combo packagingCombo;
    private Combo classifierCombo;
    Button createChecksumButton;
    Button generatePomButton;
    private final IFile file;

    public MavenInstallFileArtifactWizardPage(IFile file) {
        super("mavenInstallFileWizardPage");
        this.file = file;
        this.setTitle(Messages.MavenInstallFileArtifactWizardPage_title);
        this.setDescription(Messages.MavenInstallFileArtifactWizardPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        ModifyListener modifyingListener = e -> this.pageChanged();
        Label artifactFileNameLabel = new Label(container, 0);
        artifactFileNameLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblFileName);
        this.artifactFileNameText = new Text(container, 2048);
        this.artifactFileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.artifactFileNameText.setData("name", (Object)"artifactFileNametext");
        this.artifactFileNameText.addModifyListener(e -> {
            this.updateFileName(this.getArtifactFileName());
            this.pageChanged();
        });
        Button artifactFileNameButton = new Button(container, 0);
        artifactFileNameButton.setLayoutData((Object)new GridData());
        artifactFileNameButton.setData("name", (Object)"externalPomFileButton");
        artifactFileNameButton.setText(Messages.MavenInstallFileArtifactWizardPage_btnFilename);
        artifactFileNameButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fileDialog = new FileDialog(artifactFileNameButton.getShell());
            fileDialog.setText(Messages.MavenInstallFileArtifactWizardPage_file_title);
            fileDialog.setFileName(this.artifactFileNameText.getText());
            String name = fileDialog.open();
            if (name != null) {
                this.updateFileName(name);
            }
        }));
        Label pomFileNameLabel = new Label(container, 0);
        pomFileNameLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblPom);
        this.pomFileNameText = new Text(container, 2048);
        this.pomFileNameText.setData("name", (Object)"pomFileNameText");
        this.pomFileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pomFileNameText.addModifyListener(e -> {
            this.generatePomButton.setSelection(this.getPomFileName().length() == 0);
            this.pageChanged();
        });
        Button pomFileNameButton = new Button(container, 0);
        pomFileNameButton.setLayoutData((Object)new GridData());
        pomFileNameButton.setData("name", (Object)"externalPomFileButton");
        pomFileNameButton.setText(Messages.MavenInstallFileArtifactWizardPage_btnPom);
        pomFileNameButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fileDialog = new FileDialog(pomFileNameButton.getShell());
            fileDialog.setText(Messages.MavenInstallFileArtifactWizardPage_file_title);
            fileDialog.setFileName(this.pomFileNameText.getText());
            String res = fileDialog.open();
            if (res != null) {
                this.updatePOMFileName(res);
            }
        }));
        new Label(container, 0);
        this.generatePomButton = new Button(container, 32);
        this.generatePomButton.setData("name", (Object)"generatePomButton");
        this.generatePomButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.generatePomButton.setText(Messages.MavenInstallFileArtifactWizardPage_btnGenerate);
        this.generatePomButton.setSelection(true);
        new Label(container, 0);
        this.createChecksumButton = new Button(container, 32);
        this.createChecksumButton.setData("name", (Object)"createChecksumButton");
        this.createChecksumButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.createChecksumButton.setText(Messages.MavenInstallFileArtifactWizardPage_btnChecksum);
        this.createChecksumButton.setSelection(true);
        Label separator = new Label(container, 258);
        GridData separatorData = new GridData(4, 0x1000000, false, false, 3, 1);
        separatorData.verticalIndent = 5;
        separator.setLayoutData((Object)separatorData);
        Label groupIdlabel = new Label(container, 0);
        groupIdlabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblgroupid);
        this.groupIdCombo = new Combo(container, 0);
        this.groupIdCombo.setData("name", (Object)"groupIdCombo");
        this.groupIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.groupIdCombo.addModifyListener(modifyingListener);
        new Label(container, 0);
        Label artifactIdLabel = new Label(container, 0);
        artifactIdLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblArtifact);
        this.artifactIdCombo = new Combo(container, 0);
        this.artifactIdCombo.setData("name", (Object)"artifactIdCombo");
        this.artifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.artifactIdCombo.addModifyListener(modifyingListener);
        new Label(container, 0);
        Label versionLabel = new Label(container, 0);
        versionLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblVersion);
        this.versionCombo = new Combo(container, 0);
        this.versionCombo.setData("name", (Object)"versionCombo");
        this.versionCombo.setText("0.0.1-SNAPSHOT");
        GridData versionComboData = new GridData(16384, 0x1000000, false, false, 2, 1);
        versionComboData.widthHint = 150;
        this.versionCombo.setLayoutData((Object)versionComboData);
        this.versionCombo.addModifyListener(modifyingListener);
        Label packagingLabel = new Label(container, 0);
        packagingLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblPackaging);
        this.packagingCombo = new Combo(container, 0);
        this.packagingCombo.setData("name", (Object)"packagingCombo");
        this.packagingCombo.setText("jar");
        this.packagingCombo.setItems(MavenArtifactComponent.PACKAGING_OPTIONS);
        GridData packagingComboData = new GridData(16384, 0x1000000, false, false, 2, 1);
        packagingComboData.widthHint = 150;
        this.packagingCombo.setLayoutData((Object)packagingComboData);
        this.packagingCombo.addModifyListener(modifyingListener);
        Label classifierLabel = new Label(container, 0);
        classifierLabel.setText(Messages.MavenInstallFileArtifactWizardPage_lblClassifier);
        this.classifierCombo = new Combo(container, 0);
        this.classifierCombo.setData("name", (Object)"classifierText");
        this.classifierCombo.setItems(new String[]{"sources", "javadoc"});
        GridData classifierTextData = new GridData(16384, 0x1000000, false, false, 2, 1);
        classifierTextData.widthHint = 150;
        this.classifierCombo.setLayoutData((Object)classifierTextData);
        this.classifierCombo.addModifyListener(e -> this.generatePomButton.setSelection(this.getClassifier().length() == 0));
        if (this.file != null) {
            this.updateFileName(this.file.getLocation().toOSString());
        }
        this.setControl((Control)container);
    }

    void updateFileName(String fileName) {
        ArtifactKey artifactKey;
        String pomFileName;
        Object iaf;
        int n;
        File file;
        if (!this.getArtifactFileName().equals(fileName)) {
            this.artifactFileNameText.setText(fileName);
        }
        if (!(file = new File(fileName)).exists() || !file.isFile()) {
            return;
        }
        if (fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".ear")) {
            this.packagingCombo.setText(fileName.substring(fileName.length() - 3));
        }
        if ((n = fileName.lastIndexOf(46)) > -1) {
            String pomFileName2 = fileName.substring(0, n) + ".pom";
            if (new File(pomFileName2).exists()) {
                this.pomFileNameText.setText(pomFileName2);
            }
        } else {
            this.pomFileNameText.setText("");
        }
        if ((iaf = null) != null) {
            this.groupIdCombo.setText(iaf.group);
            this.artifactIdCombo.setText(iaf.artifact);
            this.versionCombo.setText(iaf.version);
            if (iaf.classifier != null) {
                this.classifierCombo.setText(iaf.classifier);
            }
            String name = iaf.group + ":" + iaf.artifact + "-" + iaf.version + (iaf.classifier == null ? "" : iaf.classifier);
            this.setMessage(NLS.bind((String)Messages.MavenInstallFileArtifactWizardPage_message, (Object)name), 2);
            return;
        }
        if (n > -1 && new File(pomFileName = fileName.substring(0, n) + ".pom").exists()) {
            this.pomFileNameText.setText(pomFileName);
            this.readPOMFile(pomFileName);
        }
        if ((artifactKey = SelectionUtil.getType(file, ArtifactKey.class)) != null) {
            this.groupIdCombo.setText(artifactKey.groupId());
            this.artifactIdCombo.setText(artifactKey.artifactId());
            this.versionCombo.setText(artifactKey.version());
            if (artifactKey.classifier() != null) {
                this.classifierCombo.setText(artifactKey.classifier());
            }
        }
    }

    private void updatePOMFileName(String fileName) {
        File file;
        if (!this.getPomFileName().equals(fileName)) {
            this.pomFileNameText.setText(fileName);
        }
        if (!((file = new File(fileName)).exists() && file.isFile() && fileName.endsWith(".pom"))) {
            return;
        }
        this.readPOMFile(fileName);
    }

    private void readPOMFile(String fileName) {
        try {
            IMaven maven = MavenPlugin.getMaven();
            MavenProject mavenProject = maven.readProject(new File(fileName), null);
            this.groupIdCombo.setText(mavenProject.getGroupId());
            this.artifactIdCombo.setText(mavenProject.getArtifactId());
            this.versionCombo.setText(mavenProject.getVersion());
            this.packagingCombo.setText(mavenProject.getPackaging());
            return;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return;
        }
    }

    void pageChanged() {
        String artifactFileName = this.getArtifactFileName();
        if (artifactFileName.length() == 0) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_no_name);
            return;
        }
        File file = new File(artifactFileName);
        if (!file.exists() || !file.isFile()) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_missing);
            return;
        }
        String pomFileName = this.getPomFileName();
        if (pomFileName.length() > 0 && !new File(pomFileName).exists()) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_missingpom);
            return;
        }
        if (this.getGroupId().length() == 0) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_groupid);
            return;
        }
        if (this.getArtifactId().length() == 0) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_artifactid);
            return;
        }
        if (this.getVersion().length() == 0) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_version);
            return;
        }
        if (this.getPackaging().length() == 0) {
            this.updateStatus(Messages.MavenInstallFileArtifactWizardPage_error_packaging);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getArtifactFileName() {
        return this.artifactFileNameText.getText().trim();
    }

    public String getPomFileName() {
        return this.pomFileNameText.getText().trim();
    }

    public String getGroupId() {
        return this.groupIdCombo.getText().trim();
    }

    public String getArtifactId() {
        return this.artifactIdCombo.getText().trim();
    }

    public String getVersion() {
        return this.versionCombo.getText().trim();
    }

    public String getPackaging() {
        return this.packagingCombo.getText().trim();
    }

    public String getClassifier() {
        return this.classifierCombo.getText().trim();
    }

    public boolean isGeneratePom() {
        return this.generatePomButton.getSelection();
    }

    public boolean isCreateChecksum() {
        return this.createChecksumButton.getSelection();
    }
}

