"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogLevel = void 0;
/**
 * The level of verbosity that the language service logs at.
 */
var LogLevel;
(function (LogLevel) {
    /** Disable logging */
    LogLevel[LogLevel["Off"] = 0] = "Off";
    /** Log verbose info about language server operation, such as when references are re-computed for a md file. */
    LogLevel[LogLevel["Debug"] = 1] = "Debug";
    /** Log extremely verbose info about language server operation, such as calls into the file system */
    LogLevel[LogLevel["Trace"] = 2] = "Trace";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
//# sourceMappingURL=logging.js.map