/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowInWebBrowserCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        final IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final List<IDockerPortMapping> portMappings = CommandUtils.getSelectedPortMappings(activePart);
        if (portMappings == null || portMappings.isEmpty()) {
            return null;
        }
        Job job = new Job(CommandMessages.getString("command.showIn.webBrowser")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IDockerConnection currentConnection = CommandUtils.getCurrentConnection(activePart);
                    IDockerPortMapping selectedPort = (IDockerPortMapping)portMappings.get(0);
                    URI connectionURI = new URI(currentConnection.getUri());
                    if ("tcp".equalsIgnoreCase(connectionURI.getScheme()) || "unix".equalsIgnoreCase(connectionURI.getScheme()) || "http".equalsIgnoreCase(connectionURI.getScheme()) || "https".equalsIgnoreCase(connectionURI.getScheme())) {
                        String host = "unix".equalsIgnoreCase(connectionURI.getScheme()) ? "127.0.0.1" : connectionURI.getHost();
                        URL location = new URL("http", host, selectedPort.getPublicPort(), "/");
                        ShowInWebBrowserCommandHandler.this.openLocationInWebBrowser(location);
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    Activator.logErrorMessage((String)CommandMessages.getString("command.showIn.webBrowser.failure"), (Throwable)e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void openLocationInWebBrowser(URL location) {
        Display.getDefault().asyncExec(() -> {
            try {
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(38, "org.eclipse.linuxtools.docker.core", CommandMessages.getString("ShowInWebBrowserCommandHandler.internal.browser.label"), CommandMessages.getString("ShowInWebBrowserCommandHandler.internal.browser.tooltip"));
                browser.openURL(location);
            }
            catch (Exception e) {
                Activator.log((IStatus)Status.error((String)CommandMessages.getString("command.showIn.webBrowser.failure"), (Throwable)e));
            }
        });
    }
}

