/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteDebugOptions;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final JSchConnection fConnection;
    private final Map<String, String> fRemoteEnv = new HashMap<String, String>();
    private final Set<Character> charSet = new HashSet<Character>();
    private Channel fChannel;
    private Map<String, String> fNewRemoteEnv;
    private boolean fPreamble = true;
    private boolean fShell = false;

    public JSchProcessBuilder(IRemoteConnection connection, List<String> command) {
        super(connection, command);
        this.fConnection = (JSchConnection)connection.getService(JSchConnection.class);
        this.fRemoteEnv.putAll(this.fConnection.getEnv());
        Object trustedChars = null;
        trustedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        trustedChars = (String)trustedChars + "0123456789/._-";
        StringCharacterIterator it = new StringCharacterIterator((String)trustedChars);
        char c = it.first();
        while (c != '\uffff') {
            this.charSet.add(Character.valueOf(c));
            c = it.next();
        }
    }

    public JSchProcessBuilder(IRemoteConnection connection, String ... command) {
        this(connection, Arrays.asList(command));
    }

    public JSchProcessBuilder(IRemoteConnection connection) {
        this(connection, new ArrayList<String>());
        this.fShell = true;
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        IRemoteFileService fileService = (IRemoteFileService)this.fConnection.getRemoteConnection().getService(IRemoteFileService.class);
        if (dir == null && fileService != null) {
            dir = fileService.getResource(this.fConnection.getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    public Map<String, String> environment() {
        if (this.fNewRemoteEnv == null) {
            this.fNewRemoteEnv = new HashMap<String, String>();
            this.fNewRemoteEnv.putAll(this.fRemoteEnv);
        }
        return this.fNewRemoteEnv;
    }

    public int getSupportedFlags() {
        return 3;
    }

    public IRemoteProcess start(int flags) throws IOException {
        if (!this.fConnection.hasOpenSession()) {
            throw new IOException(Messages.JSchProcessBuilder_Connection_is_not_open);
        }
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1 && !this.fShell) {
            throw new IndexOutOfBoundsException();
        }
        Object remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = (String)remoteCmd + " ";
            }
            remoteCmd = (String)remoteCmd + this.charEscapify((String)cmdArgs.get(i), this.charSet);
            ++i;
        }
        ArrayList<String> env = new ArrayList<String>();
        boolean clearEnv = false;
        if (this.fNewRemoteEnv != null) {
            for (String string : this.fRemoteEnv.keySet()) {
                if (this.fNewRemoteEnv.get(string) != null) continue;
                clearEnv = true;
                break;
            }
            if (clearEnv) {
                for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                    env.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            } else {
                for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                    String oldValue = this.fRemoteEnv.get(entry.getKey());
                    if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                    env.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
        }
        try {
            if (this.fShell) {
                this.fChannel = this.fConnection.getShellChannel();
                if ((flags & 1) == 1) {
                    ((ChannelShell)this.fChannel).setPty(true);
                    ((ChannelShell)this.fChannel).setPtyType((flags & 2) == 2 ? "xterm" : "vt100");
                }
                RemoteDebugOptions.trace((String)"/debug/commands", (String)"executing shell", (String[])new String[0]);
            } else {
                this.fChannel = this.fConnection.getExecChannel();
                String string = this.buildCommand((String)remoteCmd, env, clearEnv);
                ((ChannelExec)this.fChannel).setCommand(string);
                if ((flags & 1) == 1) {
                    ((ChannelExec)this.fChannel).setPty(true);
                    ((ChannelExec)this.fChannel).setPtyType((flags & 2) == 2 ? "xterm" : "vt100");
                }
                RemoteDebugOptions.trace((String)"/debug/commands", (String)("executing command: " + string), (String[])new String[0]);
            }
            this.fChannel.setXForwarding((flags & 2) == 2);
            this.fChannel.connect();
            return this.newRemoteProcess();
        }
        catch (RemoteConnectionException remoteConnectionException) {
            throw new IOException(remoteConnectionException.getMessage());
        }
        catch (JSchException jSchException) {
            throw new IOException(jSchException.getMessage());
        }
    }

    public Channel getChannel() {
        return this.fChannel;
    }

    public void setPreamble(boolean enable) {
        this.fPreamble = enable;
    }

    private String buildCommand(String cmd, List<String> environment, boolean clearEnv) {
        StringBuffer sb = new StringBuffer();
        if (this.fPreamble) {
            if (this.directory() != null) {
                sb.append("cd " + this.charEscapify(this.directory().toURI().getPath(), this.charSet) + " && ");
            }
            if (clearEnv) {
                sb.append("env -i");
                for (String env : environment) {
                    sb.append(" \"" + env + "\"");
                }
                sb.append(" ");
            } else {
                for (String env : environment) {
                    sb.append("export \"" + env + "\"; ");
                }
            }
        }
        sb.append(cmd);
        if (this.fPreamble && this.fConnection.useLoginShell()) {
            return this.substitute(this.fConnection.getLoginShellCommand(), sb.toString());
        }
        return sb.toString();
    }

    private String charEscapify(String inputString, Set<Character> charSet) {
        if (inputString == null) {
            return null;
        }
        StringBuffer newString = new StringBuffer("");
        StringCharacterIterator it = new StringCharacterIterator(inputString);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\'') {
                newString.append("'\\\\\\''");
            } else if (c > '\u007f' || charSet.contains(Character.valueOf(c))) {
                newString.append(c);
            } else {
                newString.append("\\" + c);
            }
            c = it.next();
        }
        inputString = newString.toString();
        return inputString;
    }

    private String substitute(String str, String ... args) {
        int length = str.length();
        StringBuffer buffer = new StringBuffer(length + args.length * 5);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '{': {
                    int index = str.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        break;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(str.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        buffer.append("<invalid argument>");
                        i = index;
                        break;
                    }
                    if (number >= args.length || number < 0) {
                        buffer.append("<missing argument>");
                        i = index;
                        break;
                    }
                    buffer.append(args[number]);
                    i = index;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

