/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons;

import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.commons.TextDocumentVersionChecker;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ModelTextDocument<T>
extends TextDocument {
    private static final Logger LOGGER = Logger.getLogger(ModelTextDocument.class.getName());
    private final BiFunction<TextDocument, CancelChecker, T> parse;
    private T model;

    public ModelTextDocument(TextDocumentItem document, BiFunction<TextDocument, CancelChecker, T> parse) {
        super(document);
        this.parse = parse;
    }

    public ModelTextDocument(String text, String uri, BiFunction<TextDocument, CancelChecker, T> parse) {
        super(text, uri);
        this.parse = parse;
    }

    public T getExistingModel() {
        return this.model;
    }

    public T getModel() {
        if (this.model == null) {
            return this.getSynchronizedModel();
        }
        return this.model;
    }

    private synchronized T getSynchronizedModel() {
        if (this.model != null) {
            return this.model;
        }
        int version = super.getVersion();
        long start = System.currentTimeMillis();
        try {
            LOGGER.fine("Start parsing of model with version '" + version);
            TextDocumentVersionChecker cancelChecker = new TextDocumentVersionChecker(this, version);
            this.model = this.parse.apply(this, cancelChecker);
        }
        catch (CancellationException e) {
            LOGGER.fine("Stop parsing parsing of model with version '" + version + "' in " + (System.currentTimeMillis() - start) + "ms");
            throw e;
        }
        finally {
            LOGGER.fine("End parse of model with version '" + version + "' in " + (System.currentTimeMillis() - start) + "ms");
        }
        return this.model;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.cancelModel();
    }

    @Override
    public void setVersion(int version) {
        super.setVersion(version);
        this.cancelModel();
    }

    private void cancelModel() {
        this.model = null;
    }
}

