/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class FacetDataModelOperation
extends AbstractDataModelOperation {
    public FacetDataModelOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            IFacetedProject facetProj = this.createProject(monitor);
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            actions.add(new IFacetedProject.Action((IFacetedProject.Action.Type)this.model.getProperty("IFacetDataModelProperties.FACET_TYPE"), (IProjectFacetVersion)this.model.getProperty("IFacetDataModelPropeties.FACET_VERSION"), (Object)this.model));
            facetProj.modify(actions, monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return OK_STATUS;
    }

    public IFacetedProject createProject(IProgressMonitor monitor) throws CoreException {
        IProject project = ProjectUtilities.getProject((String)((String)this.model.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")));
        IFacetedProject facetProj = null;
        if (project.exists()) {
            facetProj = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        } else {
            String location = null;
            if (this.model.isProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION")) {
                location = (String)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION");
            }
            Path locationPath = location == null ? null : new Path(location);
            facetProj = ProjectFacetsManager.create((String)this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"), (IPath)locationPath, (IProgressMonitor)monitor);
        }
        if (this.model.isProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            IRuntime existingRuntime = facetProj.getPrimaryRuntime();
            if (!(runtime == null || existingRuntime != null && runtime.equals(existingRuntime))) {
                facetProj.setTargetedRuntimes(Collections.singleton(runtime), null);
            }
        }
        return facetProj;
    }
}

