/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTClassVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVirtSpecifier;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements ICReconcilingListener {
    private CEditor fEditor;
    protected SemanticHighlightingPresenter fPresenter;
    protected SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fHighlightings;
    protected List<SemanticHighlightingManager.HighlightedPosition> fAddedPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>();
    protected List<SemanticHighlightingManager.HighlightedPosition> fRemovedPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>();
    protected int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    protected SemanticHighlightingPresenter fJobPresenter;
    protected SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fJobHighlightings;

    @Override
    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        block24: {
            block23: {
                Object object;
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    if (this.fIsReconciling) {
                        return;
                    }
                    this.fIsReconciling = true;
                }
                this.fJobPresenter = this.fPresenter;
                this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                this.fJobHighlightings = this.fHighlightings;
                try {
                    if (this.fJobPresenter != null && this.fJobSemanticHighlightings != null && this.fJobHighlightings != null) break block23;
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    object = this.fReconcileLock;
                }
                catch (Throwable throwable) {
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    Object object3 = this.fReconcileLock;
                    synchronized (object3) {
                        this.fIsReconciling = false;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                return;
            }
            this.fJobPresenter.setCanceled(progressMonitor != null && progressMonitor.isCanceled());
            if (ast != null && !this.fJobPresenter.isCanceled()) break block24;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.fIsReconciling = false;
            }
            return;
        }
        PositionCollector collector = new PositionCollector();
        this.startReconcilingPositions();
        if (!this.fJobPresenter.isCanceled()) {
            this.reconcilePositions(ast, collector);
        }
        TextPresentation textPresentation = null;
        if (!this.fJobPresenter.isCanceled()) {
            textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
        }
        if (!this.fJobPresenter.isCanceled()) {
            this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
        }
        this.stopReconcilingPositions();
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
        }
    }

    protected void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(IASTTranslationUnit ast, PositionCollector visitor) {
        try {
            CPPSemantics.pushLookupPoint((IASTNode)ast);
            ast.accept((ASTVisitor)visitor);
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
        List<SemanticHighlightingManager.HighlightedPosition> oldPositions = this.fRemovedPositions;
        ArrayList<SemanticHighlightingManager.HighlightedPosition> newPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
        Collections.sort(this.fAddedPositions, new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                return p1.getOffset() - p2.getOffset();
            }
        });
    }

    protected void updatePresentation(TextPresentation textPresentation, List<SemanticHighlightingManager.HighlightedPosition> addedPositions, List<SemanticHighlightingManager.HighlightedPosition> removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        CEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    protected void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(CEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.HighlightingStyle[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fEditor.addReconcileListener(this);
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            this.fEditor = null;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        IWorkingCopy element = this.fEditor.getInputCElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(CEditorMessages.SemanticHighlighting_job, (ICElement)element){
                    private final /* synthetic */ ICElement val$element;
                    {
                        this.val$element = iCElement;
                        super($anonymous0);
                    }

                    protected IStatus run(final IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                CUIPlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final 2 me = this;
                        ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                        IStatus status = astProvider.runOnAST(this.val$element, ASTProvider.WAIT_IF_OPEN, monitor, new ASTCache.ASTRunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                SemanticHighlightingReconciler.this.reconciled(ast, true, monitor);
                                Object object = (this).SemanticHighlightingReconciler.this.fJobLock;
                                synchronized (object) {
                                    if ((this).SemanticHighlightingReconciler.this.fJob == me) {
                                        (this).SemanticHighlightingReconciler.this.fJob = null;
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        });
                        return status;
                    }
                };
                this.fJob.setPriority(20);
                this.fJob.schedule();
            }
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    public static abstract class AbstractPositionCollector
    extends ASTVisitor {
        private SemanticHighlighting[] fHighlightings;
        private SemanticHighlightingManager.HighlightingStyle[] fHighlightingStyles;
        private SemanticToken fToken = new SemanticToken();

        public AbstractPositionCollector(SemanticHighlighting[] highlightings, SemanticHighlightingManager.HighlightingStyle[] highlightingStyles) {
            this.fHighlightings = highlightings;
            this.fHighlightingStyles = highlightingStyles;
            PositionCollectorRequirements requirements = this.getRequirements();
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = requirements.visitExpressions;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitNamespaces = true;
            this.shouldVisitVirtSpecifiers = true;
            this.shouldVisitImplicitNames = requirements.visitImplicitNames;
            this.shouldVisitImplicitNameAlternates = requirements.visitImplicitNames;
        }

        private PositionCollectorRequirements getRequirements() {
            PositionCollectorRequirements result = new PositionCollectorRequirements();
            int i = 0;
            while (i < this.fHighlightings.length) {
                SemanticHighlighting sh = this.fHighlightings[i];
                if (this.fHighlightingStyles[i].isEnabled()) {
                    if (sh.requiresImplicitNames()) {
                        result.visitImplicitNames = true;
                    }
                    if (sh.requiresExpressions()) {
                        result.visitExpressions = true;
                    }
                }
                ++i;
            }
            return result;
        }

        public int visit(IASTTranslationUnit tu) {
            IASTPreprocessorMacroExpansion[] macroExps;
            IASTPreprocessorMacroDefinition[] macroDefs;
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = macroDefs = tu.getMacroDefinitions();
            int n = macroDefs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorMacroDefinition macroDef = iASTPreprocessorMacroDefinitionArray[n2];
                if (macroDef.isPartOfTranslationUnitFile()) {
                    this.visitNode((IASTNode)macroDef.getName());
                }
                ++n2;
            }
            IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = macroExps = tu.getMacroExpansions();
            int n3 = macroExps.length;
            n = 0;
            while (n < n3) {
                IASTPreprocessorMacroExpansion macroExp = iASTPreprocessorMacroExpansionArray[n];
                if (macroExp.isPartOfTranslationUnitFile()) {
                    IASTName[] nestedMacroRefs;
                    IASTName macroRef = macroExp.getMacroReference();
                    this.visitNode((IASTNode)macroRef);
                    IASTName[] iASTNameArray = nestedMacroRefs = macroExp.getNestedMacroReferences();
                    int n4 = nestedMacroRefs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTName nestedMacroRef = iASTNameArray[n5];
                        this.visitNode((IASTNode)nestedMacroRef);
                        ++n5;
                    }
                }
                ++n;
            }
            return super.visit(tu);
        }

        public int visit(IASTDeclaration declaration) {
            if (!declaration.isPartOfTranslationUnitFile()) {
                return 1;
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            return 3;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            if (!namespace.isPartOfTranslationUnitFile()) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTDeclarator declarator) {
            return 3;
        }

        public int visit(IASTStatement statement) {
            return 3;
        }

        public int visit(IASTName name) {
            if (this.visitNode((IASTNode)name)) {
                return 1;
            }
            return 3;
        }

        public int visit(ICPPASTVirtSpecifier virtSpecifier) {
            this.visitNode((IASTNode)virtSpecifier);
            return 3;
        }

        public int visit(ICPPASTClassVirtSpecifier classVirtSpecifier) {
            this.visitNode((IASTNode)classVirtSpecifier);
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (this.visitNode((IASTNode)expression)) {
                return 1;
            }
            return 3;
        }

        private boolean visitNode(IASTNode node) {
            try {
                CPPSemantics.pushLookupPoint((IASTNode)node);
                boolean consumed = false;
                this.fToken.update(node);
                int i = 0;
                int n = this.fHighlightings.length;
                while (i < n) {
                    SemanticHighlighting semanticHighlighting = this.fHighlightings[i];
                    if ((!(node instanceof IASTExpression) || semanticHighlighting.requiresExpressions()) && this.fHighlightingStyles[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                        IASTNodeLocation location = this.getLocationToHighlight(node);
                        if (location != null) {
                            this.highlightLocation(location, this.fHighlightingStyles[i]);
                        }
                        consumed = true;
                        break;
                    }
                    ++i;
                }
                this.fToken.clear();
                boolean bl = consumed;
                return bl;
            }
            finally {
                CPPSemantics.popLookupPoint();
            }
        }

        private IASTNodeLocation getLocationToHighlight(IASTNode node) {
            IASTNodeLocation nodeLocation;
            IASTNodeLocation[] nodeLocations;
            IASTImageLocation imageLocation = null;
            if (node instanceof IASTName) {
                imageLocation = ((IASTName)node).getImageLocation();
            } else if (node instanceof ASTNode) {
                imageLocation = ((ASTNode)node).getImageLocation();
            }
            if (imageLocation != null) {
                if (imageLocation.getLocationKind() != 2) {
                    return imageLocation;
                }
            } else if (!(node instanceof ASTPreprocessorName) && (nodeLocations = node.getNodeLocations()).length == 1 && !((nodeLocation = nodeLocations[0]) instanceof IASTMacroExpansionLocation)) {
                return nodeLocation;
            }
            return null;
        }

        private void highlightLocation(IASTNodeLocation nodeLocation, SemanticHighlightingManager.HighlightingStyle highlightingStyle) {
            int offset = nodeLocation.getNodeOffset();
            int length = nodeLocation.getNodeLength();
            if (offset > -1 && length > 0) {
                this.addPosition(offset, length, highlightingStyle);
            }
        }

        protected abstract void addPosition(int var1, int var2, SemanticHighlightingManager.HighlightingStyle var3);

        private class PositionCollectorRequirements {
            public boolean visitImplicitNames = false;
            public boolean visitExpressions = false;

            private PositionCollectorRequirements() {
            }
        }
    }

    private class PositionCollector
    extends AbstractPositionCollector {
        public PositionCollector() {
            super(SemanticHighlightingReconciler.this.fJobSemanticHighlightings, SemanticHighlightingReconciler.this.fJobHighlightings);
        }

        @Override
        protected void addPosition(int offset, int length, SemanticHighlightingManager.HighlightingStyle highlightingStyle) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fRemovedPositions.get(i);
                if (position != null && position.isEqual(offset, length, highlightingStyle)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    --SemanticHighlightingReconciler.this.fNOfRemovedPositions;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlightingStyle);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }
    }
}

