/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.viewmodel;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.MessagesForVariablesVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class DsfCastToTypeSupport {
    private final DsfServicesTracker serviceTracker;
    private final AbstractDMVMProvider dmvmProvider;
    private final SyncVariableDataAccess fSyncVariableDataAccess;
    private Map<String, IExpressions2.CastInfo> fCastedExpressionStorage = new HashMap<String, IExpressions2.CastInfo>();

    public DsfCastToTypeSupport(DsfSession session, AbstractDMVMProvider dmvmProvider, SyncVariableDataAccess fSyncVariableDataAccess) {
        this.dmvmProvider = dmvmProvider;
        this.fSyncVariableDataAccess = fSyncVariableDataAccess;
        this.serviceTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
    }

    public String createCastedExpressionMemento(IExpressions.IExpressionDMContext exprDMC) {
        if (exprDMC instanceof IExpressions2.ICastedExpressionDMContext) {
            IExpressions.IExpressionDMContext origExpr = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)exprDMC.getParents()[0], IExpressions.IExpressionDMContext.class);
            if (origExpr == null) {
                assert (false);
            } else {
                exprDMC = origExpr;
            }
        }
        String expression = exprDMC.getExpression();
        String memento = exprDMC.getSessionId() + "." + expression;
        return memento;
    }

    public IExpressions.IExpressionDMContext replaceWithCastedExpression(IExpressions.IExpressionDMContext exprDMC) {
        String memento;
        IExpressions2.CastInfo castInfo;
        IExpressions2 expression2Service = (IExpressions2)this.serviceTracker.getService(IExpressions2.class);
        if (expression2Service == null) {
            return exprDMC;
        }
        if (!this.fCastedExpressionStorage.isEmpty() && (castInfo = this.fCastedExpressionStorage.get(memento = this.createCastedExpressionMemento(exprDMC))) != null) {
            return expression2Service.createCastedExpression(exprDMC, castInfo);
        }
        return exprDMC;
    }

    public ICastToArray getCastImpl(IExpressions.IExpressionDMContext exprDMC) {
        return new CastImplementation(exprDMC);
    }

    public class CastImplementation
    extends PlatformObject
    implements ICastToArray {
        private final IExpressions.IExpressionDMContext exprDMC;
        private String memento;

        public CastImplementation(IExpressions.IExpressionDMContext exprDMC) {
            this.exprDMC = exprDMC;
            this.memento = DsfCastToTypeSupport.this.createCastedExpressionMemento(exprDMC);
        }

        private boolean isValid() {
            if (this.exprDMC instanceof IExpressions.IIndexedPartitionDMContext || this.exprDMC instanceof IExpressions.IExpressionGroupDMContext) {
                return false;
            }
            TestExpressions2Query query = new TestExpressions2Query();
            DsfCastToTypeSupport.this.dmvmProvider.getSession().getExecutor().execute((Runnable)((Object)query));
            try {
                return (Boolean)query.get();
            }
            catch (InterruptedException e) {
                assert (false);
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }

        private void throwIfNotValid() throws DebugException {
            if (!this.isValid()) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10005, MessagesForVariablesVM.VariableVMNode_CannotCastVariable, null));
            }
        }

        public boolean canCast() {
            return this.isValid();
        }

        public String getCurrentType() {
            IExpressions2.CastInfo castDMC = DsfCastToTypeSupport.this.fCastedExpressionStorage.get(this.memento);
            if (castDMC != null && castDMC.getTypeString() != null) {
                return castDMC.getTypeString();
            }
            IExpressions.IExpressionDMData data = DsfCastToTypeSupport.this.fSyncVariableDataAccess.readVariable(this.exprDMC);
            if (data != null) {
                return data.getTypeName();
            }
            return "";
        }

        public void cast(String type) throws DebugException {
            this.throwIfNotValid();
            IExpressions2.CastInfo currentContext = DsfCastToTypeSupport.this.fCastedExpressionStorage.get(this.memento);
            this.updateCastInformation(type, currentContext != null ? currentContext.getArrayStartIndex() : 0, currentContext != null ? currentContext.getArrayCount() : 0);
        }

        public void restoreOriginal() throws DebugException {
            this.throwIfNotValid();
            DsfCastToTypeSupport.this.fCastedExpressionStorage.remove(this.memento);
            this.fireExpressionChangedEvent(this.exprDMC);
        }

        public boolean isCasted() {
            if (this.isValid()) {
                return DsfCastToTypeSupport.this.fCastedExpressionStorage.containsKey(this.memento);
            }
            return false;
        }

        public boolean canCastToArray() {
            return this.isValid();
        }

        public void castToArray(int startIndex, int length) throws DebugException {
            this.throwIfNotValid();
            IExpressions2.CastInfo currentContext = DsfCastToTypeSupport.this.fCastedExpressionStorage.get(this.memento);
            this.updateCastInformation(currentContext != null ? currentContext.getTypeString() : null, startIndex, length);
        }

        private void updateCastInformation(String type, int arrayStartIndex, int arrayCount) {
            IExpressions2.CastInfo info = new IExpressions2.CastInfo(type, arrayStartIndex, arrayCount);
            DsfCastToTypeSupport.this.fCastedExpressionStorage.put(this.memento, info);
            this.fireExpressionChangedEvent(this.exprDMC);
        }

        private void fireExpressionChangedEvent(IExpressions.IExpressionDMContext exprDMC) {
            ExpressionChangedEvent event = new ExpressionChangedEvent(exprDMC);
            DsfCastToTypeSupport.this.dmvmProvider.handleEvent((Object)event);
        }

        private class ExpressionChangedEvent
        extends AbstractDMEvent<IExpressions.IExpressionDMContext>
        implements IExpressions.IExpressionChangedDMEvent {
            public ExpressionChangedEvent(IExpressions.IExpressionDMContext context) {
                super((IDMContext)context);
            }
        }

        public class TestExpressions2Query
        extends Query<Boolean> {
            protected void execute(DataRequestMonitor<Boolean> rm) {
                DsfSession session = DsfSession.getSession((String)((CastImplementation)CastImplementation.this).DsfCastToTypeSupport.this.dmvmProvider.getSession().getId());
                if (session == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10001, "Debug session already shut down.", null));
                    rm.done();
                    return;
                }
                DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), ((CastImplementation)CastImplementation.this).DsfCastToTypeSupport.this.dmvmProvider.getSession().getId());
                IExpressions2 expressions2 = (IExpressions2)tracker.getService(IExpressions2.class);
                rm.setData((Object)(expressions2 != null ? 1 : 0));
                rm.done();
                tracker.dispose();
            }
        }
    }
}

