/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTAmbiguousTypeConstraintVsNonTypeTemplateArgument
extends ASTAmbiguousNode
implements ICPPASTTemplateParameter {
    private List<IASTNode> fNodes = new ArrayList<IASTNode>(2);
    private IScope fScope;
    private ICPPASTTemplateParameter fParameter;

    @Override
    protected void beforeResolution() {
        this.fScope = CPPVisitor.getContainingScope(this);
        IScope iScope = this.fScope;
        if (iScope instanceof ICPPASTInternalScope) {
            ICPPASTInternalScope internalScope = (ICPPASTInternalScope)iScope;
            internalScope.populateCache();
        }
    }

    @Override
    protected void beforeAlternative(IASTNode alternative) {
        this.cleanupScope();
        if (alternative instanceof ICPPASTTemplateParameter) {
            ICPPASTTemplateParameter parameter = (ICPPASTTemplateParameter)alternative;
            IScope iScope = this.fScope;
            if (iScope instanceof ICPPASTInternalScope) {
                ICPPASTInternalScope internalScope = (ICPPASTInternalScope)iScope;
                this.fParameter = parameter;
                CPPSemantics.populateCache(internalScope, this.fParameter);
            }
        }
    }

    private void cleanupScope() {
        IScope iScope = this.fScope;
        if (iScope instanceof ICPPASTInternalScope) {
            ICPPASTInternalScope internalScope = (ICPPASTInternalScope)iScope;
            if (this.fParameter != null) {
                internalScope.removeNestedFromCache(this.fParameter);
            }
        }
    }

    @Override
    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
        this.beforeAlternative(best);
        this.fParameter = null;
        this.fScope = null;
    }

    @Override
    public boolean isParameterPack() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPASTTemplateParameter copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPASTTemplateParameter copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTNode[] getNodes() {
        return this.fNodes.toArray(new IASTNode[this.fNodes.size()]);
    }

    public void addTypeConstraint(ICPPASTSimpleTypeTemplateParameter typeConstraint) {
        this.assertNotFrozen();
        this.addNode(typeConstraint);
    }

    public void addNonTypeParameter(ICPPASTParameterDeclaration nonTypeParameter) {
        this.assertNotFrozen();
        this.addNode(nonTypeParameter);
    }

    private void addNode(IASTNode node) {
        this.fNodes.add(node);
        node.setParent(this);
        node.setPropertyInParent(ICPPASTTemplateDeclaration.PARAMETER);
    }
}

