/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.fs;

import java.util.Iterator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.internal.checkers.fs.CFormatStringParser;
import org.eclipse.cdt.codan.internal.checkers.fs.VulnerableFormatStringArgument;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;

public class ScanfFormatStringSecurityChecker
extends AbstractIndexAstChecker {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.ScanfFormatStringSecurityProblem";
    private static final VulnerableFunction[] VULNERABLE_FUNCTIONS = new VulnerableFunction[]{new VulnerableFunction("scanf", 0), new VulnerableFunction("fscanf", 1), new VulnerableFunction("fwscanf", 1), new VulnerableFunction("wscanf", 0), new VulnerableFunction("swscanf", 1), new VulnerableFunction("sscanf", 1)};

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new FormatStringVisitor());
    }

    private class FormatStringVisitor
    extends ASTVisitor {
        private FormatStringVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression callExpression = (IASTFunctionCallExpression)expression;
                VulnerableFunction vulnerableFunction = this.getVulnerableFunctionForExpression(callExpression);
                if (vulnerableFunction == null) {
                    return 3;
                }
                IASTInitializerClause[] arguments = callExpression.getArguments();
                int stringArgumentIndex = vulnerableFunction.getFormatStringArgumentIndex();
                this.detectFaulyArguments(callExpression, arguments, stringArgumentIndex);
            }
            return 3;
        }

        private VulnerableFunction getVulnerableFunctionForExpression(IASTFunctionCallExpression callExpression) {
            String rawSignature = callExpression.getFunctionNameExpression().getRawSignature();
            int i = 0;
            while (i < VULNERABLE_FUNCTIONS.length) {
                if (VULNERABLE_FUNCTIONS[i].getName().equals(rawSignature)) {
                    return VULNERABLE_FUNCTIONS[i];
                }
                ++i;
            }
            return null;
        }

        private void detectFaulyArguments(IASTFunctionCallExpression callExpression, IASTInitializerClause[] arguments, int formatStringArgumentIndex) {
            IASTInitializerClause formatArgument = arguments[formatStringArgumentIndex];
            String formatArgumentValue = formatArgument.getRawSignature();
            CFormatStringParser formatStringParser = new CFormatStringParser(formatArgumentValue);
            if (!formatStringParser.isVulnerable()) {
                return;
            }
            Iterator<VulnerableFormatStringArgument> vulnerableArgumentsIterator = formatStringParser.getVulnerableArgumentsIterator();
            while (vulnerableArgumentsIterator.hasNext()) {
                long arraySize;
                Number sizeNum;
                IArrayType arrayExpressionType;
                IValue sizeVal;
                IASTIdExpression idExpression;
                IType expressionType;
                int suspectArgumentIndex;
                IASTInitializerClause suspectArgument;
                VulnerableFormatStringArgument currentArgument = vulnerableArgumentsIterator.next();
                int argumentIndex = currentArgument.getArgumentIndex();
                int argumentSize = currentArgument.getArgumentSize();
                if (argumentSize == -1) {
                    ScanfFormatStringSecurityChecker.this.reportProblem(ScanfFormatStringSecurityChecker.ER_ID, (IASTNode)callExpression, new Object[]{callExpression.getRawSignature()});
                }
                if (!((suspectArgument = arguments[suspectArgumentIndex = 1 + formatStringArgumentIndex + argumentIndex]) instanceof IASTIdExpression) || !((expressionType = (idExpression = (IASTIdExpression)suspectArgument).getExpressionType()) instanceof IArrayType) || (sizeVal = (arrayExpressionType = (IArrayType)expressionType).getSize()) == null || (sizeNum = sizeVal.numberValue()) == null || (long)argumentSize <= (arraySize = sizeNum.longValue())) continue;
                ScanfFormatStringSecurityChecker.this.reportProblem(ScanfFormatStringSecurityChecker.ER_ID, (IASTNode)idExpression, new Object[]{idExpression.getRawSignature()});
            }
        }
    }

    private static final class VulnerableFunction {
        private final String name;
        private final int formatStringArgumentIndex;

        private VulnerableFunction(String name, int formatStringArgumentIndex) {
            this.name = name;
            this.formatStringArgumentIndex = formatStringArgumentIndex;
        }

        public String getName() {
            return this.name;
        }

        public int getFormatStringArgumentIndex() {
            return this.formatStringArgumentIndex;
        }
    }
}

