/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.AbstractIdentifiable;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.Identifiable;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;

public class DataModelEnablementFactory {
    public static IDataModel createDataModel(String providerKind, IProject curProject) {
        String[] providerIDs = DataModelFactory.getDataModelProviderIDsForKind(providerKind);
        if (providerIDs == null || providerIDs.length == 0) {
            return null;
        }
        String topProvider = DataModelEnablementFactory.getHighestPriorityEnabledProviderDesc(providerIDs, curProject);
        if (topProvider == null) {
            return null;
        }
        return DataModelFactory.createDataModel(topProvider);
    }

    private static String getHighestPriorityEnabledProviderDesc(String[] providerIDs, IProject curProject) {
        String defaultID = providerIDs[0];
        Identifiable topPriorityIdentifiable = null;
        int i = 1;
        while (i < providerIDs.length) {
            AbstractIdentifiable tempIdentifiable = new AbstractIdentifiable(providerIDs[i]);
            IEnablementIdentifier enablementIdentifier = EnablementManager.INSTANCE.getIdentifier(tempIdentifiable.getID(), curProject);
            if (enablementIdentifier.isEnabled()) {
                if (topPriorityIdentifiable == null) {
                    topPriorityIdentifiable = tempIdentifiable;
                } else if (IdentifiableComparator.instance.compare(tempIdentifiable, topPriorityIdentifiable) == 1) {
                    topPriorityIdentifiable = tempIdentifiable;
                }
            }
            ++i;
        }
        if (topPriorityIdentifiable == null) {
            return defaultID;
        }
        return topPriorityIdentifiable.getID();
    }
}

