/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class NestedProjectsContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    public static final String EXTENSION_ID = "org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    private final Command projectPresetionCommand;
    private CommonViewer viewer;

    public NestedProjectsContentProvider() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.projectPresetionCommand = commandService.getCommand("org.eclipse.ui.navigator.resources.nested.changeProjectPresentation");
        try {
            HandlerUtil.updateRadioState((Command)this.projectPresetionCommand, (String)Boolean.TRUE.toString());
        }
        catch (ExecutionException ex) {
            WorkbenchNavigatorPlugin.log(ex.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        try {
            HandlerUtil.updateRadioState((Command)this.projectPresetionCommand, (String)Boolean.FALSE.toString());
        }
        catch (ExecutionException ex) {
            WorkbenchNavigatorPlugin.log(ex.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
        this.ensureFiltersActivated();
    }

    private void ensureFiltersActivated() {
        INavigatorFilterService filterService = this.viewer.getNavigatorContentService().getFilterService();
        HashSet<String> filters = new HashSet<String>();
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = filterService.getVisibleFilterDescriptors();
        int n = iCommonFilterDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor desc = iCommonFilterDescriptorArray[n2];
            if (filterService.isActive(desc.getId())) {
                filters.add(desc.getId());
            }
            ++n2;
        }
        if (!filters.contains("org.eclipse.ui.navigator.resources.nested.HideTopLevelProjectIfNested") || !filters.contains("org.eclipse.ui.navigator.resources.nested.HideFolderWhenProjectIsShownAsNested")) {
            filters.add("org.eclipse.ui.navigator.resources.nested.HideTopLevelProjectIfNested");
            filters.add("org.eclipse.ui.navigator.resources.nested.HideFolderWhenProjectIsShownAsNested");
            filterService.activateFilterIdsAndUpdateViewer(filters.toArray(new String[filters.size()]));
        }
    }

    public Object[] getElements(Object inputElement) {
        return EMPTY_OBJECT_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public IProject[] getChildren(Object parentElement) {
        void container;
        if (!(parentElement instanceof IContainer)) {
            return EMPTY_PROJECT_ARRAY;
        }
        IContainer iContainer = (IContainer)parentElement;
        return NestedProjectManager.getInstance().getDirectChildrenProjects((IContainer)container);
    }

    public IContainer getParent(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            if (NestedProjectManager.getInstance().isShownAsNested(project)) {
                return NestedProjectManager.getInstance().getMostDirectOpenContainer(project);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IContainer) {
            return NestedProjectManager.getInstance().hasDirectChildrenProjects((IContainer)element);
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null || event.getType() != 1) {
            return;
        }
        LinkedHashSet<IContainer> parentsToRefresh = new LinkedHashSet<IContainer>();
        if (delta.getKind() == 4 && delta.getResource() instanceof IWorkspaceRoot) {
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                IResource childResource = childDelta.getResource();
                if (childResource instanceof IProject) {
                    IProject affectedProject = (IProject)childResource;
                    if (childDelta.getKind() == 1 || childDelta.getKind() == 2) {
                        IContainer parent = this.getParent(affectedProject);
                        if (parent != null) {
                            parentsToRefresh.add(parent);
                        } else {
                            parentsToRefresh.clear();
                            parentsToRefresh.add(affectedProject.getParent());
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        if (!parentsToRefresh.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (this.viewer.getTree() == null || this.viewer.getTree().isDisposed()) {
                    return;
                }
                for (IContainer parent : parentsToRefresh) {
                    this.viewer.refresh((Object)parent);
                }
            });
        }
    }
}

