/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DefaultDynamicTestInvocationContext;
import org.junit.jupiter.engine.descriptor.DynamicNodeTestDescriptor;
import org.junit.jupiter.engine.execution.InvocationInterceptorChain;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.Node;

class DynamicTestTestDescriptor
extends DynamicNodeTestDescriptor {
    private static final InvocationInterceptorChain interceptorChain = new InvocationInterceptorChain();
    private @Nullable DynamicTest dynamicTest;

    DynamicTestTestDescriptor(UniqueId uniqueId, int index, DynamicTest dynamicTest, @Nullable TestSource source, JupiterConfiguration configuration) {
        super(uniqueId, index, (DynamicNode)dynamicTest, source, configuration);
        this.dynamicTest = dynamicTest;
    }

    @Override
    protected DynamicTestTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new DynamicTestTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.index, Objects.requireNonNull(this.dynamicTest), (TestSource)this.getSource().orElse(null), this.configuration);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        DefaultDynamicTestInvocationContext dynamicTestInvocationContext = new DefaultDynamicTestInvocationContext(this.requiredDynamicTest().getExecutable());
        ExtensionContext extensionContext = context.getExtensionContext();
        MutableExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        interceptorChain.invoke(this.toInvocation(), extensionRegistry, InvocationInterceptorChain.InterceptorCall.ofVoid((interceptor, wrappedInvocation) -> interceptor.interceptDynamicTest(wrappedInvocation, dynamicTestInvocationContext, extensionContext)));
        return context;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    InvocationInterceptor.Invocation<@Nullable Void> toInvocation() {
        return () -> {
            this.requiredDynamicTest().getExecutable().execute();
            return null;
        };
    }

    public void after(JupiterEngineExecutionContext context) throws Exception {
        super.after((EngineExecutionContext)context);
        this.dynamicTest = null;
    }

    private DynamicTest requiredDynamicTest() {
        return Objects.requireNonNull(this.dynamicTest);
    }
}

