/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.expressions.EditWatchExpressinInPlaceAction;
import org.eclipse.debug.internal.ui.actions.expressions.PasteWatchExpressionsAction;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.expression.ExpressionDropAdapter;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.SelectionDragAdapter;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class ExpressionView
extends VariablesView {
    private PasteWatchExpressionsAction fPasteAction;
    private EditWatchExpressinInPlaceAction fEditInPlaceAction;

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.expression_view_context";
    }

    @Override
    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IContributionItem)new Separator("emptyExpressionGroup"));
        tbm.add((IContributionItem)new Separator("expressionGroup"));
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        ChangeVariableValueAction changeValueAction;
        Object action;
        menu.add((IContributionItem)new Separator("emptyExpressionGroup"));
        menu.add((IContributionItem)new Separator("expressionGroup"));
        if (DebugPlugin.getDefault().getExpressionManager().getExpressions().length > 0) {
            action = this.getAction(FIND_ACTION);
            action.setImageDescriptor(DebugPluginImages.getImageDescriptor("FIND_ACTION_ICON"));
            menu.add(action);
        }
        if ((changeValueAction = (ChangeVariableValueAction)this.getAction("ChangeVariableValue")).isApplicable()) {
            menu.add((IAction)changeValueAction);
        }
        menu.add((IContributionItem)new Separator());
        action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add(action);
        }
        action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null || selection.isEmpty()) {
            super.contextActivated((ISelection)new StructuredSelection((Object)DebugPlugin.getDefault().getExpressionManager()));
        } else {
            super.contextActivated(selection);
        }
        if (this.isAvailable() && this.isVisible()) {
            this.updateAction("ContentAssist");
        }
    }

    @Override
    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        IStatus status = update.getStatus();
        if ((status == null || status.isOK()) && update.getElement() != null) {
            this.setViewerInput(update.getInputElement());
        } else {
            this.setViewerInput(DebugPlugin.getDefault().getExpressionManager());
        }
        this.updateAction(FIND_ACTION);
    }

    @Override
    protected String getDetailPanePreferenceKey() {
        return "Expressions.detail.orientation";
    }

    @Override
    protected String getToggleActionLabel() {
        return VariablesViewMessages.ExpressionView_4;
    }

    @Override
    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.ExpressionView";
    }

    @Override
    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter(viewer));
        viewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()}, (DropTargetListener)new ExpressionDropAdapter(this.getSite(), viewer));
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fPasteAction = new PasteWatchExpressionsAction(this);
        this.configure((IAction)this.fPasteAction, "org.eclipse.ui.edit.paste", PASTE_ACTION, "IMG_TOOL_PASTE");
        this.fEditInPlaceAction = new EditWatchExpressinInPlaceAction(this);
        this.configure((IAction)this.fEditInPlaceAction, "org.eclipse.ui.edit.rename", ActionFactory.RENAME.getId(), null);
    }

    @Override
    public void dispose() {
        this.fEditInPlaceAction.dispose();
        super.dispose();
    }

    private void configure(IAction action, String defId, String globalId, String imgId) {
        this.setAction(globalId, action);
        action.setActionDefinitionId(defId);
        this.setGlobalAction(globalId, action);
        if (imgId != null) {
            action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imgId));
        }
    }

    public boolean canPaste() {
        return true;
    }

    public boolean performPaste() {
        String clipboardText = this.getClipboardText();
        if (clipboardText != null && clipboardText.length() > 0) {
            IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
            IWatchExpression watchExpression = expressionManager.newWatchExpression(clipboardText);
            expressionManager.addExpression((IExpression)watchExpression);
            watchExpression.setExpressionContext(this.getContext());
            return true;
        }
        return false;
    }

    protected IDebugElement getContext() {
        IAdaptable object = DebugUITools.getPartDebugContext(this.getSite());
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        return context;
    }

    protected String getClipboardText() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            String string = (String)clipboard.getContents((Transfer)textTransfer);
            return string;
        }
        finally {
            clipboard.dispose();
        }
    }
}

