/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.console;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.console.ConsoleDocument;
import org.eclipse.m2e.core.ui.internal.console.IMavenConsoleListener;
import org.eclipse.m2e.core.ui.internal.console.MavenConsole;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class MavenConsoleImpl
extends IOConsole
implements MavenConsole,
IPropertyChangeListener {
    private boolean initialized = false;
    private boolean visible = false;
    private ConsoleDocument consoleDocument;
    private Color messageColor;
    private IOConsoleOutputStream commandStream;
    private IOConsoleOutputStream messageStream;
    private IOConsoleOutputStream errorStream;
    private static final String TITLE = Messages.MavenConsoleImpl_title;
    private final List<IMavenConsoleListener> listeners = new CopyOnWriteArrayList<IMavenConsoleListener>();

    public MavenConsoleImpl(ImageDescriptor imageDescriptor) {
        super(TITLE, imageDescriptor);
        this.setConsoleDocument(new ConsoleDocument());
    }

    protected void init() {
        super.init();
        Display.getDefault().asyncExec(() -> {
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.initializeConsoleStreams(Display.getDefault());
            this.dumpConsole();
        });
    }

    protected void initializeConsoleStreams(Display display) {
        if (!this.initialized) {
            this.setCommandStream(this.newOutputStream());
            this.setErrorStream(this.newOutputStream());
            this.setMessageStream(this.newOutputStream());
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            Color background = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
            if (background == null) {
                background = JFaceColors.getInformationViewerBackgroundColor((Display)display);
            }
            this.setBackground(background);
            Color commandColor = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND");
            if (commandColor == null) {
                commandColor = JFaceColors.getInformationViewerForegroundColor((Display)display);
            }
            this.messageColor = new Color((Device)display, commandColor.getRGB(), 200);
            Color errorColor = colorRegistry.get("ERROR_COLOR");
            if (errorColor == null) {
                errorColor = JFaceColors.getErrorText((Display)display);
            }
            this.getCommandStream().setColor(commandColor);
            this.getMessageStream().setColor(this.messageColor);
            this.getErrorStream().setColor(errorColor);
            this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
            this.initialized = true;
        }
    }

    protected void dumpConsole() {
        ConsoleDocument.ConsoleLine[] lines;
        this.setVisible(true);
        ConsoleDocument.ConsoleLine[] consoleLineArray = lines = this.getConsoleDocument().getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleDocument.ConsoleLine line = consoleLineArray[n2];
            this.appendLine(line.type, line.line);
            ++n2;
        }
        this.getConsoleDocument().clear();
    }

    private void appendLine(int type, String line) {
        this.show(false);
        Display.getDefault().asyncExec(() -> {
            if (this.isVisible()) {
                try {
                    switch (type) {
                        case 0: {
                            this.getCommandStream().write(line);
                            this.getCommandStream().write(10);
                            break;
                        }
                        case 1: {
                            this.getMessageStream().write(line);
                            this.getMessageStream().write(10);
                            break;
                        }
                        case 2: {
                            this.getErrorStream().write(line);
                            this.getErrorStream().write(10);
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.getConsoleDocument().appendConsoleLine(type, line);
            }
        });
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat) {
            if (!this.isVisible()) {
                this.showConsole();
            } else {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
            }
        }
    }

    public void showConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (!Arrays.asList(manager.getConsoles()).contains(this)) {
            manager.addConsoles(new IConsole[]{this});
        }
        manager.showConsoleView((IConsole)this);
    }

    public void closeConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.removeConsoles(new IConsole[]{this});
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this.newLifecycle());
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
    }

    private void bringConsoleToFront() {
        if (PlatformUI.isWorkbenchRunning()) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (!this.isVisible()) {
                manager.addConsoles(new IConsole[]{this});
            }
            manager.showConsoleView((IConsole)this);
        }
    }

    protected void dispose() {
        Display.getDefault().asyncExec(() -> {
            this.setVisible(false);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        });
    }

    public void shutdown() {
        super.dispose();
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
    }

    private DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
    }

    @Override
    public void debug(String message) {
        if (!M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.debugOutput")) {
            return;
        }
        if (this.showConsoleOnOutput()) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, this.getDateFormat().format(new Date()) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message) {
        if (this.showConsoleOnOutput()) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, this.getDateFormat().format(new Date()) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message) {
        if (this.showConsoleOnError()) {
            this.bringConsoleToFront();
        }
        this.appendLine(2, this.getDateFormat().format(new Date()) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingError(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean showConsoleOnError() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.showConsoleOnErr");
    }

    public boolean showConsoleOnOutput() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.showConsoleOnOutput");
    }

    public IConsoleListener newLifecycle() {
        return new MavenConsoleLifecycle();
    }

    protected void setCommandStream(IOConsoleOutputStream commandStream) {
        this.commandStream = commandStream;
    }

    protected IOConsoleOutputStream getCommandStream() {
        return this.commandStream;
    }

    protected void setMessageStream(IOConsoleOutputStream messageStream) {
        this.messageStream = messageStream;
    }

    protected IOConsoleOutputStream getMessageStream() {
        return this.messageStream;
    }

    protected void setErrorStream(IOConsoleOutputStream errorStream) {
        this.errorStream = errorStream;
    }

    protected IOConsoleOutputStream getErrorStream() {
        return this.errorStream;
    }

    protected void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected boolean isVisible() {
        return this.visible;
    }

    private void setConsoleDocument(ConsoleDocument consoleDocument) {
        this.consoleDocument = consoleDocument;
    }

    protected ConsoleDocument getConsoleDocument() {
        return this.consoleDocument;
    }

    public void addMavenConsoleListener(IMavenConsoleListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeMavenConsoleListener(IMavenConsoleListener listener) {
        this.listeners.remove(listener);
    }

    public class MavenConsoleLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == MavenConsoleImpl.this) {
                    MavenConsoleImpl.this.init();
                }
                ++n2;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == MavenConsoleImpl.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    MavenConsoleImpl.this.dispose();
                }
                ++n2;
            }
        }
    }
}

