/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.StringFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class StringCleanUpCore
extends AbstractMultiFix {
    private CompilationUnit fSavedCompilationUnit = null;

    public StringCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public StringCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        return this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        ICleanUpFix coreFix = StringFixCore.createCleanUp(this.fSavedCompilationUnit == null ? compilationUnit : this.fSavedCompilationUnit, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
        return coreFix;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        ArrayList<IProblemLocation> coreProblems = new ArrayList<IProblemLocation>();
        IProblemLocation[] iProblemLocationArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            coreProblems.add(problem);
            ++n2;
        }
        ICleanUpFix coreFix = StringFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
        return coreFix;
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            result.add(MultiFixMessages.StringMultiFix_AddMissingNonNls_description);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result.add(MultiFixMessages.StringMultiFix_RemoveUnnecessaryNonNls_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            buf.append("public String s;");
        } else {
            buf.append("public String s; //$NON-NLS-1$");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 536871177) {
            return this.isEnabled("cleanup.remove_unnecessary_nls_tags");
        }
        if (problem.getProblemId() == 536871173) {
            return this.isEnabled("cleanup.add_missing_nls_tags");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        try {
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            if (!cu.isStructureKnown()) {
                return 0;
            }
        }
        catch (JavaModelException e) {
            return 0;
        }
        this.fSavedCompilationUnit = compilationUnit;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            result += StringCleanUpCore.getNumberOfProblems(problems, 536871173);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            result += StringCleanUpCore.getNumberOfProblems(problems, 536871177);
        }
        return result;
    }
}

