/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.List;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.util.TString;
import org.eclipse.jface.dialogs.IInputValidator;

public class QueryNameValidator
implements IInputValidator {
    List currentNamesList = null;

    public QueryNameValidator(List names) {
        this.currentNamesList = names;
    }

    public String containsInvalidChar(String text) {
        String[] invalidChars = new String[]{"?", "\"", "<", ">", "\\", "|", ":", "*", "#", "/"};
        int i = 0;
        while (i < invalidChars.length) {
            if (text.indexOf(invalidChars[i]) != -1) {
                return invalidChars[i];
            }
            ++i;
        }
        return "";
    }

    public String isValid(String newText) {
        String invalidChar;
        String returnMessage = null;
        if (newText.equals("") || newText.indexOf(" ") != -1) {
            returnMessage = Messages._ERROR_INVALID_STATEMENT_NAME;
        }
        if (!(invalidChar = this.containsInvalidChar(newText)).equals("")) {
            String msg1 = Messages._ERROR_INVALID_CHAR_IN_STATEMENT_NAME;
            returnMessage = TString.change(msg1, "%1", invalidChar);
        }
        if (newText.length() > 160) {
            returnMessage = Messages._ERROR_STATEMENT_NAME_TOO_LONG;
        }
        if (this.currentNamesList != null) {
            for (String name : this.currentNamesList) {
                if (!newText.toUpperCase().equals(name.toUpperCase())) continue;
                String msg2 = Messages._ERROR_STATEMENT_NAME_EXISTS;
                returnMessage = TString.change(msg2, "%1", newText);
            }
        }
        return returnMessage;
    }
}

