/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.mapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttribute;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.annotate.mapping.JoinTableAttributes;
import org.eclipse.jpt.jpa.db.Table;

public class EntityRefPropertyElem
extends EntityPropertyElem {
    public static final String ASCENDING = "Ascending";
    public static final String DESCENDING = "Descending";
    private String refEntityClassName;
    private Table refTable;
    private JoinTableAttributes joinTable;
    private List<ColumnAttributes> joinColumns;
    private List<ColumnAttributes> inverseJoinColumns;
    private List<ColumnAttributes> pkJoinColumns;
    private List<String> cascades;
    private String mapKey;
    private String orderBy;
    private JoinStrategy joinStrategy;

    public EntityRefPropertyElem(String fqClassName, Table table) {
        super(fqClassName, table);
        this.cascades = new ArrayList<String>();
        this.joinColumns = new ArrayList<ColumnAttributes>();
        this.inverseJoinColumns = new ArrayList<ColumnAttributes>();
        this.pkJoinColumns = new ArrayList<ColumnAttributes>();
    }

    public EntityRefPropertyElem(String fqClassName, Table table, String propName, String propType) {
        super(fqClassName, table, propName, propType);
        this.cascades = new ArrayList<String>();
        this.joinColumns = new ArrayList<ColumnAttributes>();
        this.inverseJoinColumns = new ArrayList<ColumnAttributes>();
        this.pkJoinColumns = new ArrayList<ColumnAttributes>();
    }

    public EntityRefPropertyElem(EntityRefPropertyElem another) {
        super(another);
        this.refEntityClassName = another.refEntityClassName;
        this.refTable = another.refTable;
        this.mapKey = another.mapKey;
        this.orderBy = another.orderBy;
        this.joinStrategy = another.joinStrategy;
        if (another.joinTable != null) {
            this.joinTable = new JoinTableAttributes(another.joinTable);
        }
        this.cascades = new ArrayList<String>();
        this.joinColumns = new ArrayList<ColumnAttributes>();
        this.inverseJoinColumns = new ArrayList<ColumnAttributes>();
        this.pkJoinColumns = new ArrayList<ColumnAttributes>();
        this.cascades.addAll(another.cascades);
        this.joinColumns.addAll(another.joinColumns);
        this.inverseJoinColumns.addAll(another.inverseJoinColumns);
        this.pkJoinColumns.addAll(another.pkJoinColumns);
    }

    public String getRefEntityClassName() {
        return this.refEntityClassName;
    }

    public void setRefEntityClassName(String refClass) {
        this.refEntityClassName = refClass;
    }

    public Table getReferencedTable() {
        return this.refTable;
    }

    public void setReferencedTable(Table refTable) {
        this.refTable = refTable;
    }

    public boolean isManyToOne() {
        return this.getTagName().equals("many-to-one");
    }

    public boolean isOneToOne() {
        return this.getTagName().equals("one-to-one");
    }

    public boolean isOneToMany() {
        return this.getTagName().equals("one-to-many");
    }

    public boolean isManyToMany() {
        return this.getTagName().equals("many-to-many");
    }

    public boolean isEntityCollection() {
        return this.isOneToMany() || this.isManyToMany();
    }

    public void setJoinTable(JoinTableAttributes joinTable) {
        this.joinTable = joinTable;
    }

    public JoinTableAttributes getJoinTable() {
        return this.joinTable;
    }

    public void removeJoinTable() {
        if (this.joinTable != null) {
            this.joinTable.dispose();
        }
        this.joinTable = null;
    }

    public void removeMappedBy() {
        if (this.getAnnotationAttrs() != null) {
            this.getAnnotationAttrs().removeAnnotationAttribute("mappedBy");
        }
    }

    public void addJoinColumn(ColumnAttributes joinColumn) {
        this.joinColumns.add(joinColumn);
    }

    public List<ColumnAttributes> getJoinColumns() {
        return this.joinColumns;
    }

    public void removeAllJoinColumns() {
        this.joinColumns.clear();
    }

    public void setJoinColumns(List<ColumnAttributes> joinColumns) {
        this.joinColumns.clear();
        if (joinColumns != null) {
            this.joinColumns.addAll(joinColumns);
        }
    }

    public void addInverseJoinColumn(ColumnAttributes joinColumn) {
        this.inverseJoinColumns.add(joinColumn);
    }

    public List<ColumnAttributes> getInverseJoinColumns() {
        return this.inverseJoinColumns;
    }

    public void removeAllInverseJoinColumns() {
        this.inverseJoinColumns.clear();
    }

    public void setInverseJoinColumns(List<ColumnAttributes> joinColumns) {
        this.inverseJoinColumns.clear();
        if (joinColumns != null) {
            this.inverseJoinColumns.addAll(joinColumns);
        }
    }

    public void addPkJoinColumn(ColumnAttributes joinColumn) {
        this.pkJoinColumns.add(joinColumn);
    }

    public List<ColumnAttributes> getPkJoinColumns() {
        return this.pkJoinColumns;
    }

    public void removeAllPKJoinColumns() {
        this.pkJoinColumns.clear();
    }

    public void setPKJoinColumns(List<ColumnAttributes> joinColumns) {
        this.pkJoinColumns.clear();
        if (joinColumns != null) {
            this.pkJoinColumns.addAll(joinColumns);
        }
    }

    public String getMappedBy() {
        AnnotationAttribute attr;
        String mappedBy = null;
        if (this.getAnnotationAttrs() != null && (attr = this.getAnnotationAttrs().getAnnotationAttribute("mappedBy")) != null) {
            mappedBy = attr.attrValue;
        }
        return mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        AnnotationAttribute attr = new AnnotationAttribute("mappedBy", mappedBy);
        this.setAnnotationAttr(attr);
    }

    public List<String> getAllCascades() {
        return this.cascades;
    }

    public void addCascade(String cascade) {
        this.cascades.add(cascade);
    }

    public void removeAllCascades() {
        this.cascades.clear();
    }

    public void setCascades(List<String> cascades) {
        assert (cascades != null);
        this.cascades.clear();
        this.cascades.addAll(cascades);
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }
}

