/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

public final class MergeAlgorithm {
    private final DiffAlgorithm diffAlg;
    @NonNull
    private ContentMergeStrategy strategy = ContentMergeStrategy.CONFLICT;
    private static final Edit END_EDIT = new Edit(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public MergeAlgorithm() {
        this(new HistogramDiff());
    }

    public MergeAlgorithm(DiffAlgorithm diff) {
        this.diffAlg = diff;
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.strategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.strategy = strategy == null ? ContentMergeStrategy.CONFLICT : strategy;
    }

    private static boolean isEndEdit(Edit edit) {
        return edit == END_EDIT;
    }

    public <S extends Sequence> MergeResult<S> merge(SequenceComparator<S> cmp, S base, S ours, S theirs) {
        ArrayList<S> sequences = new ArrayList<S>(3);
        sequences.add(base);
        sequences.add(ours);
        sequences.add(theirs);
        MergeResult result = new MergeResult(sequences);
        if (ours.size() == 0) {
            if (theirs.size() != 0) {
                EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
                if (!theirsEdits.isEmpty()) {
                    switch (this.strategy) {
                        case OURS: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        case THEIRS: 
                        case UNION: {
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NO_CONFLICT);
                            break;
                        }
                        default: {
                            result.add(1, 0, 0, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                            result.add(0, 0, base.size(), MergeChunk.ConflictState.BASE_CONFLICTING_RANGE);
                            result.add(2, 0, theirs.size(), MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                            break;
                        }
                    }
                } else {
                    result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                }
            } else {
                result.add(1, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        if (theirs.size() == 0) {
            EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
            if (!oursEdits.isEmpty()) {
                switch (this.strategy) {
                    case OURS: 
                    case UNION: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, 0, ours.size(), MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        result.add(0, 0, base.size(), MergeChunk.ConflictState.BASE_CONFLICTING_RANGE);
                        result.add(2, 0, 0, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                        break;
                    }
                }
            } else {
                result.add(2, 0, 0, MergeChunk.ConflictState.NO_CONFLICT);
            }
            return result;
        }
        EditList oursEdits = this.diffAlg.diff(cmp, base, ours);
        Iterator<Edit> baseToOurs = oursEdits.iterator();
        EditList theirsEdits = this.diffAlg.diff(cmp, base, theirs);
        Iterator<Edit> baseToTheirs = theirsEdits.iterator();
        int current = 0;
        Edit oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
        Edit theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
        while (!MergeAlgorithm.isEndEdit(theirsEdit) || !MergeAlgorithm.isEndEdit(oursEdit)) {
            if (oursEdit.getEndA() < theirsEdit.getBeginA()) {
                if (current != oursEdit.getBeginA()) {
                    result.add(0, current, oursEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(1, oursEdit.getBeginB(), oursEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = oursEdit.getEndA();
                oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
                continue;
            }
            if (theirsEdit.getEndA() < oursEdit.getBeginA()) {
                if (current != theirsEdit.getBeginA()) {
                    result.add(0, current, theirsEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(2, theirsEdit.getBeginB(), theirsEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = theirsEdit.getEndA();
                theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                continue;
            }
            if (oursEdit.getBeginA() != current && theirsEdit.getBeginA() != current) {
                result.add(0, current, Math.min(oursEdit.getBeginA(), theirsEdit.getBeginA()), MergeChunk.ConflictState.NO_CONFLICT);
            }
            int oursBeginA = oursEdit.getBeginA();
            int theirsBeginA = theirsEdit.getBeginA();
            int oursBeginB = oursEdit.getBeginB();
            int theirsBeginB = theirsEdit.getBeginB();
            if (oursEdit.getBeginA() < theirsEdit.getBeginA()) {
                theirsBeginA -= theirsEdit.getBeginA() - oursEdit.getBeginA();
                theirsBeginB -= theirsEdit.getBeginA() - oursEdit.getBeginA();
            } else {
                oursBeginA -= oursEdit.getBeginA() - theirsEdit.getBeginA();
                oursBeginB -= oursEdit.getBeginA() - theirsEdit.getBeginA();
            }
            Edit nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            Edit nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
            while (true) {
                if (oursEdit.getEndA() >= nextTheirsEdit.getBeginA()) {
                    theirsEdit = nextTheirsEdit;
                    nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                    continue;
                }
                if (theirsEdit.getEndA() < nextOursEdit.getBeginA()) break;
                oursEdit = nextOursEdit;
                nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            }
            int oursEndA = oursEdit.getEndA();
            int theirsEndA = theirsEdit.getEndA();
            int oursEndB = oursEdit.getEndB();
            int theirsEndB = theirsEdit.getEndB();
            if (oursEdit.getEndA() < theirsEdit.getEndA()) {
                oursEndA += theirsEdit.getEndA() - oursEdit.getEndA();
                oursEndB += theirsEdit.getEndA() - oursEdit.getEndA();
            } else {
                theirsEndA += oursEdit.getEndA() - theirsEdit.getEndA();
                theirsEndB += oursEdit.getEndA() - theirsEdit.getEndA();
            }
            int minBSize = oursEndB - oursBeginB;
            int BSizeDelta = minBSize - (theirsEndB - theirsBeginB);
            if (BSizeDelta > 0) {
                minBSize -= BSizeDelta;
            }
            int commonPrefix = 0;
            while (commonPrefix < minBSize && cmp.equals(ours, oursBeginB + commonPrefix, theirs, theirsBeginB + commonPrefix)) {
                ++commonPrefix;
            }
            minBSize -= commonPrefix;
            int commonSuffix = 0;
            while (commonSuffix < minBSize && cmp.equals(ours, oursEndB - commonSuffix - 1, theirs, theirsEndB - commonSuffix - 1)) {
                ++commonSuffix;
            }
            minBSize -= commonSuffix;
            if (commonPrefix > 0) {
                result.add(1, oursBeginB, oursBeginB + commonPrefix, MergeChunk.ConflictState.NO_CONFLICT);
            }
            if (minBSize > 0 || BSizeDelta != 0) {
                switch (this.strategy) {
                    case OURS: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    case UNION: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        result.add(1, oursBeginB + commonPrefix, oursEndB - commonSuffix, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
                        int baseBegin = Math.min(oursBeginA, theirsBeginA) + commonPrefix;
                        int baseEnd = Math.min(base.size(), Math.max(oursEndA, theirsEndA)) - commonSuffix;
                        result.add(0, baseBegin, baseEnd, MergeChunk.ConflictState.BASE_CONFLICTING_RANGE);
                        result.add(2, theirsBeginB + commonPrefix, theirsEndB - commonSuffix, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
                    }
                }
            }
            if (commonSuffix > 0) {
                result.add(1, oursEndB - commonSuffix, oursEndB, MergeChunk.ConflictState.NO_CONFLICT);
            }
            current = Math.max(oursEdit.getEndA(), theirsEdit.getEndA());
            oursEdit = nextOursEdit;
            theirsEdit = nextTheirsEdit;
        }
        if (current < base.size()) {
            result.add(0, current, base.size(), MergeChunk.ConflictState.NO_CONFLICT);
        }
        return result;
    }

    private static Edit nextEdit(Iterator<Edit> it) {
        return it.hasNext() ? it.next() : END_EDIT;
    }
}

