/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class DiscriminatorClassMetadata
extends ORMetadata {
    private MetadataClass m_valueClass;
    private String m_value;
    private String m_discriminator;

    public DiscriminatorClassMetadata() {
        super("<discriminator-class>");
    }

    public DiscriminatorClassMetadata(MetadataAnnotation discriminatorClass, MetadataAccessor accessor) {
        super(discriminatorClass, accessor);
        this.setDiscriminator(discriminatorClass.getAttributeString("discriminator"));
        this.setValueClass(this.getMetadataClass(discriminatorClass.getAttributeString("value")));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof DiscriminatorClassMetadata) {
            DiscriminatorClassMetadata discriminatorClass = (DiscriminatorClassMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_value, discriminatorClass.getValue())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminator, discriminatorClass.getDiscriminator());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_value != null ? this.m_value.hashCode() : 0;
        result = 31 * result + (this.m_discriminator != null ? this.m_discriminator.hashCode() : 0);
        return result;
    }

    public String getDiscriminator() {
        return this.m_discriminator;
    }

    public MetadataClass getValueClass() {
        return this.m_valueClass;
    }

    public String getValue() {
        return this.m_value;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_valueClass = this.initXMLClassName(this.m_value);
    }

    public void process(VariableOneToOneMapping mapping) {
        if (mapping.getTypeIndicatorNameTranslation().containsValue(this.m_discriminator)) {
            throw ValidationException.multipleClassesForTheSameDiscriminator((String)this.m_discriminator, (String)mapping.getAttributeName());
        }
        mapping.addClassNameIndicator(this.m_valueClass.getName(), (Object)this.m_discriminator);
    }

    public void setDiscriminator(String discriminator) {
        this.m_discriminator = discriminator;
    }

    public void setValueClass(MetadataClass value) {
        this.m_valueClass = value;
    }

    public void setValue(String valueName) {
        this.m_value = valueName;
    }
}

