/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;

public class ReplaceNameTemplateContext
extends DocumentTemplateContext {
    private int fInsertOffset = -1;

    public ReplaceNameTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        this(type, document, new Position(offset, length));
    }

    public ReplaceNameTemplateContext(TemplateContextType type, IDocument document, Position position) {
        super(type, document, position);
    }

    public ReplaceNameTemplateContext(TemplateContextType type, IDocument document, int offset, int length, int insertOffset) {
        this(type, document, new Position(offset, length));
        this.fInsertOffset = insertOffset;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer buffer = super.evaluate(template);
        if (buffer != null && this.fInsertOffset > -1 && this.fInsertOffset > this.getStart()) {
            String prefix = this.getDocument().get(this.getStart(), this.fInsertOffset - this.getStart());
            if (!template.getName().startsWith(prefix)) {
                int prefixSize = prefix.length();
                TemplateVariable[] newTemplateVar = buffer.getVariables();
                int i = 0;
                while (i < newTemplateVar.length) {
                    int[] offsets = newTemplateVar[i].getOffsets();
                    int j = 0;
                    while (j < offsets.length) {
                        int n = j++;
                        offsets[n] = offsets[n] + prefixSize;
                    }
                    ++i;
                }
                buffer = new TemplateBuffer(String.valueOf(prefix) + buffer.getString(), newTemplateVar);
            }
        }
        return buffer;
    }
}

