/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.actions;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.actions.JDBCHelper;
import org.eclipse.datatools.enablement.sybase.asa.actions.MultiASADialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class ProfileASAMultiDBAction
implements IObjectActionDelegate {
    private IStructuredSelection mSelection = null;
    private Shell mShell = null;

    public void run(IAction action) {
        Object element;
        StructuredSelection ssel = (StructuredSelection)this.mSelection;
        if (!ssel.isEmpty() && (element = ssel.getFirstElement()) instanceof IConnectionProfile) {
            IConnectionProfile profile = (IConnectionProfile)element;
            MultiASADialog dlg = new MultiASADialog(this.mShell);
            dlg.setProfile(profile);
            int rtn = dlg.open();
            if (rtn == 0) {
                this.performFinish(profile, dlg.getDBNames());
            }
        }
    }

    public boolean performFinish(IConnectionProfile profile, String[] dbnames) {
        boolean success = false;
        Properties props = profile.getBaseProperties();
        if (dbnames != null && dbnames.length > 0) {
            List<String> names = Arrays.asList(dbnames);
            Connection conn = JDBCHelper.getConnectionForTempProfile(this.mShell, profile);
            String defaultName = JDBCHelper.getDefaultCatalogNameForProfile(conn);
            String host = props.getProperty("org.eclipse.datatools.enablement.sybase.host");
            String port = props.getProperty("org.eclipse.datatools.enablement.sybase.port");
            if (defaultName != null && defaultName.length() > 0 && names.contains(defaultName)) {
                String updatedUrl = JDBCASAPlugin.makeDriverURL((String)host, (String)port, (String)defaultName);
                props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", defaultName);
                props.setProperty("org.eclipse.datatools.connectivity.db.URL", updatedUrl);
                props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", defaultName);
                profile.setBaseProperties(props);
                try {
                    ProfileManager.getInstance().modifyProfile(profile);
                }
                catch (ConnectionProfileException e) {
                    ExceptionHandler.showException((Shell)this.mShell, (String)JDBCASAProfileMessages.format((String)"ProfileASAMultiDBAction.error.failedprofileupdate", (Object[])new String[]{profile.getName()}), (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            }
            int i = 0;
            while (i < names.size()) {
                block14: {
                    String iter_dbname = names.get(i);
                    if (defaultName == null || !defaultName.equals(iter_dbname)) {
                        boolean createIt;
                        String newprofilename;
                        String parent;
                        block13: {
                            String updatedUrl = JDBCASAPlugin.makeDriverURL((String)host, (String)port, (String)iter_dbname);
                            props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", iter_dbname);
                            props.setProperty("org.eclipse.datatools.connectivity.db.URL", updatedUrl);
                            props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", iter_dbname);
                            try {
                                parent = "";
                                if (profile.getParentProfile() != null) {
                                    parent = profile.getParentProfile().getName();
                                }
                                newprofilename = String.valueOf(profile.getName()) + "." + iter_dbname;
                                createIt = true;
                                if (ProfileManager.getInstance().getProfileByName(newprofilename) == null) break block13;
                                boolean answer = MessageDialog.openQuestion((Shell)this.mShell, (String)JDBCASAProfileMessages.getString((String)"ProfileASAMultiDBAction.error.title.profilealreadyexists"), (String)JDBCASAProfileMessages.format((String)"ProfileASAMultiDBAction.msg.profilealreadyexists", (Object[])new String[]{newprofilename}));
                                if (!answer) break block14;
                                createIt = false;
                                IConnectionProfile oldProfile = ProfileManager.getInstance().getProfileByName(newprofilename);
                                oldProfile.setBaseProperties(props);
                                try {
                                    ProfileManager.getInstance().modifyProfile(oldProfile);
                                }
                                catch (ConnectionProfileException e) {
                                    ExceptionHandler.showException((Shell)this.mShell, (String)JDBCASAProfileMessages.format((String)"ProfileASAMultiDBAction.error.failedprofileupdate", (Object[])new String[]{newprofilename}), (String)e.getLocalizedMessage(), (Throwable)e);
                                    return false;
                                }
                            }
                            catch (ConnectionProfileException e) {
                                ExceptionHandler.showException((Shell)this.mShell, (String)ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), (String)e.getLocalizedMessage(), (Throwable)e);
                                return false;
                            }
                        }
                        if (createIt) {
                            ProfileManager.getInstance().createProfile(newprofilename, profile.getDescription(), profile.getProviderId(), props, parent, profile.isAutoConnect());
                        }
                    }
                }
                ++i;
            }
            success = true;
        }
        return success;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof CommonNavigator) {
            this.mShell = ((CommonNavigator)targetPart).getSite().getShell();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = (IStructuredSelection)selection;
    }
}

