/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.routines.Source;

public class IngresTriggerSourceLoader
extends JDBCBaseLoader {
    private static final String TRIGGER_SOURCE_QUERY = "SELECT DISTINCT rule_name, rule_owner, system_use, table_name, text_sequence, text_segment FROM iirules WHERE table_name = ? AND rule_owner = ? AND rule_name = ? ORDER BY text_sequence";
    private static final String TRIGGER_SOURCE_SEGMENT = "text_segment";

    public IngresTriggerSourceLoader() {
        this(null);
    }

    public IngresTriggerSourceLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresTriggerSourceLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadSource(String tableName, String ruleOwner, String ruleName, Source source) {
        block6: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.getCatalogObject().getConnection().prepareStatement(TRIGGER_SOURCE_QUERY);
                    stmt.setString(1, tableName);
                    stmt.setString(2, ruleOwner);
                    stmt.setString(3, ruleName);
                    rs = stmt.executeQuery();
                    StringBuffer sourceBuf = new StringBuffer();
                    while (rs.next()) {
                        sourceBuf.append(rs.getString(TRIGGER_SOURCE_SEGMENT));
                    }
                    source.setBody(sourceBuf.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoaderHelper.close(rs);
                    LoaderHelper.close(stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                LoaderHelper.close(rs);
                LoaderHelper.close(stmt);
                throw throwable;
            }
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
        }
    }
}

