/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.ddl;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.ddl.CodeTemplateContextPattern;
import org.eclipse.datatools.enablement.ibm.ddl.CoreDeltaDdlGenerator;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationMessages;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.RoutineDdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.TypedElementLogicalDomainProvider;
import org.eclipse.datatools.enablement.ibm.util.AccessControlUtilities;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.AttributeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class DdlBuilder {
    protected static final String ADMIN = "ADMIN";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String UNDERSCORE = "_";
    protected static final String EMPTY_STRING = "";
    protected static final String DOT = ".";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String SINGLE_QUOTE = "'";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String TAB = "\t";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String LEFT_SQUARE = "[";
    protected static final String RIGHT_SQUARE = "]";
    protected static final String COLON = ":";
    protected static final String DROP = "DROP";
    protected static final String REMOVE = "REMOVE";
    protected static final String CREATE = "CREATE";
    protected static final String ALTER = "ALTER";
    protected static final String ADD = "ADD";
    protected static final String DELETE = "DELETE";
    protected static final String UPDATE = "UPDATE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CASCADED = "CASCADED";
    protected static final String LOCAL = "LOCAL";
    protected static final String OPTION = "OPTION";
    protected static final String RESTRICT = "RESTRICT";
    protected static final String NULL = "NULL";
    protected static final String NOT = "NOT";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String SET = "SET";
    protected static final String DATABASE = "DATABASE";
    protected static final String DATA_TYPE = "DATA TYPE";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TABLE = "TABLE";
    protected static final String COLUMN = "COLUMN";
    protected static final String TABLESPACE = "TABLESPACE";
    protected static final String VIEW = "VIEW";
    protected static final String INDEX = "INDEX";
    protected static final String ROUTINE = "ROUTINE";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String FUNCTION = "FUNCTION";
    protected static final String METHOD = "METHOD";
    protected static final String SEQUENCE = "SEQUENCE";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String CHECK = "CHECK";
    protected static final String TYPE = "TYPE";
    protected static final String ON = "ON";
    protected static final String FOREIGN_KEY = "FOREIGN KEY";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String PRIMARY_KEY = "PRIMARY KEY";
    protected static final String DEFERRABLE = "DEFERRABLE";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String INITIALLY = "INITIALLY";
    protected static final String ALIAS = "ALIAS";
    protected static final String AS = "AS";
    protected static final String FOR = "FOR";
    protected static final String DISTINCT = "DISTINCT";
    protected static final String STRUCTURED = "STRUCTURED";
    protected static final String LONG = "LONG";
    protected static final String BLOB = "BLOB";
    protected static final String DBCLOB = "DBCLOB";
    protected static final String CLOB = "CLOB";
    protected static final String VARCHAR = "VARCHAR";
    protected static final String WITH = "WITH";
    protected static final String COMPARISONS = "COMPARISONS";
    protected static final String DATALINK = "DATALINK";
    protected static final String VARGRAPHIC = "VARGRAPHIC";
    protected static final String AFTER = "AFTER";
    protected static final String BEFORE = "BEFORE";
    protected static final String INSTEAD_OF = "INSTEAD OF";
    protected static final String INSERT = "INSERT";
    protected static final String NO = "NO";
    protected static final String OF = "OF";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String NEW = "NEW";
    protected static final String OLD = "OLD";
    protected static final String NEW_TABLE = "NEW_TABLE";
    protected static final String OLD_TABLE = "OLD_TABLE";
    protected static final String EACH = "EACH";
    protected static final String ROW = "ROW";
    protected static final String STATEMENT = "STATEMENT";
    protected static final String WHEN = "WHEN";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String AUTHORIZATION = "AUTHORIZATION";
    protected static final String COMMENT = "COMMENT";
    protected static final String IS = "IS";
    protected static final String GRANT = "GRANT";
    protected static final String REVOKE = "REVOKE";
    protected static final String TO = "TO";
    protected static final String FROM = "FROM";
    protected static final String ROLE = "ROLE";
    protected static final String USER = "USER";
    protected static final String GROUP = "GROUP";
    protected static final String NO_ACTION = "NO ACTION";
    protected static final String ZERO_STRING = "0";
    protected static final String RENAME = "RENAME";
    protected static final String WHERE = "WHERE";
    protected static final String EQUALS = "=";
    protected static final String COMMENT_DELIMITER = "--";
    protected static final String LOCK = "LOCK";
    protected static final String OR = "OR";
    protected static final String USING = "USING";
    private static RoutineDdlBuilder routineDdlBuilder = null;
    private IEngineeringCallBack callback = null;
    private IEngineeringCallBack dummyCallback = null;

    public void setEngineeringCallBack(IEngineeringCallBack callback) {
        this.callback = callback;
    }

    public IEngineeringCallBack getEngineeringCallBack() {
        if (this.callback != null) {
            return this.callback;
        }
        return this.getDummyEngineeringCallBack();
    }

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames);
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = ModelHelper.getDatabase(procedure.getSchema());
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder(database.getVendor(), database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildDropRoutineStatement((Routine)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return "DROP PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = ModelHelper.getDatabase(function.getSchema());
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder(database.getVendor(), database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildDropRoutineStatement((Routine)function, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return "DROP FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames);
    }

    public String dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return "ALTER " + this.getOwnerType(constraint) + SPACE + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + " DROP CONSTRAINT " + this.getName(constraint, quoteIdentifiers, qualifyNames);
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP INDEX " + this.getName(index, quoteIdentifiers, qualifyNames);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames);
    }

    public String dropSequence(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP SEQUENCE " + this.getName(sequence, quoteIdentifiers, qualifyNames);
    }

    public String dropSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames);
    }

    protected String getCommentString(SQLObject sqlObject) {
        String comment = sqlObject.getDescription();
        if (comment == null || comment.length() == 0) {
            comment = EMPTY_STRING;
        }
        return comment;
    }

    public String commentOn(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = ModelHelper.getDatabase(procedure.getSchema());
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder(database.getVendor(), database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCommentOnStatement((Routine)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String comment = procedure.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
        return "COMMENT ON PROCEDURE " + name + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = ModelHelper.getDatabase(function.getSchema());
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder(database.getVendor(), database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCommentOnStatement((Routine)function, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String comment = function.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String functionName = this.getName((Routine)function, quoteIdentifiers, qualifyNames);
        return "COMMENT ON FUNCTION " + functionName + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = trigger.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName(trigger, quoteIdentifiers, qualifyNames);
        return "COMMENT ON TRIGGER " + name + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.commentOn(constraint, quoteIdentifiers, qualifyNames, false);
    }

    public String commentOn(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean allowEmptyComment) {
        String comment = constraint.getDescription();
        if (comment == null || comment.length() == 0) {
            if (allowEmptyComment) {
                comment = EMPTY_STRING;
            } else {
                return null;
            }
        }
        String constraintName = constraint.getName();
        String tableName = constraint.getBaseTable().getName();
        String schemaName = constraint.getBaseTable().getSchema().getName();
        if (quoteIdentifiers) {
            constraintName = this.getDoubleQuotedString(constraintName);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        constraintName = qualifyNames ? String.valueOf(schemaName) + DOT + tableName + DOT + constraintName : String.valueOf(tableName) + DOT + constraintName;
        return "COMMENT ON CONSTRAINT " + constraintName + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = index.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String indexName = this.getName(index, quoteIdentifiers, qualifyNames);
        return "COMMENT ON INDEX " + indexName + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.commentOn(sequence, quoteIdentifiers, qualifyNames, false);
    }

    public String commentOn(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames, boolean allowEmptyComment) {
        String comment = sequence.getDescription();
        if (comment == null || comment.length() == 0) {
            if (allowEmptyComment) {
                comment = EMPTY_STRING;
            } else {
                return null;
            }
        }
        String name = this.getName(sequence, quoteIdentifiers, qualifyNames);
        return "COMMENT ON SEQUENCE " + name + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = schema.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        return "COMMENT ON SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames) + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(StructuredUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = type.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames);
        return "COMMENT ON STRUCTURED TYPE " + name + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.commentOn(table, quoteIdentifiers, qualifyNames, false);
    }

    public String commentOn(Table table, boolean quoteIdentifiers, boolean qualifyNames, boolean allowEmptyComment) {
        String comment = table.getDescription();
        if (comment == null || comment.length() == 0) {
            if (allowEmptyComment) {
                comment = EMPTY_STRING;
            } else {
                return null;
            }
        }
        String name = this.getName(table, quoteIdentifiers, qualifyNames);
        return "COMMENT ON TABLE " + name + SPACE + IS + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String dropUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TYPE " + this.getName(type, quoteIdentifiers, qualifyNames);
    }

    public String createSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE SCHEMA AUTHORIZATION " + this.getName(schema, quoteIdentifiers, qualifyNames);
        return statement;
    }

    public String createTable(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + NEWLINE;
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement = String.valueOf(statement) + "\t\t" + this.getColumnString(column, quoteIdentifiers, qualifyNames);
            if (it.hasNext()) {
                statement = String.valueOf(statement) + COMMA;
            }
            statement = String.valueOf(statement) + NEWLINE;
        }
        statement = String.valueOf(statement) + "\t)";
        return statement;
    }

    public String alterTableAddColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + this.addColumnClause(column, quoteIdentifiers, qualifyNames);
            return statement;
        }
        return null;
    }

    public String addColumnClause(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String clause = "ADD COLUMN " + this.getAlterTableAddColumnColumnString(column, quoteIdentifiers, qualifyNames);
        return clause;
    }

    public String alterTableDropColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames, CoreDeltaDdlGenerator deltaGen) {
        Table table = deltaGen.getOldContainer(column);
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + this.dropColumnClause(column, quoteIdentifiers, qualifyNames, deltaGen);
            return statement;
        }
        return null;
    }

    public String dropColumnClause(Column column, boolean quoteIdentifiers, boolean qualifyNames, CoreDeltaDdlGenerator deltaGen) {
        String clause = "DROP COLUMN " + this.getColumnNameString(column, quoteIdentifiers, qualifyNames);
        return clause;
    }

    public String alterTableWithClauses(Table table, Vector<String> clauses, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE;
        boolean first = true;
        for (String clause : clauses) {
            if (!first) {
                statement = String.valueOf(statement) + NEWLINE + TAB;
            }
            statement = String.valueOf(statement) + clause;
            first = false;
        }
        return statement;
    }

    public String alterTableAlterColumnDataType(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + this.alterColumnDatatypeClause(column, quoteIdentifiers, qualifyNames);
            return statement;
        }
        return null;
    }

    public String alterColumnDatatypeClause(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columnString = "ALTER COLUMN " + columnName + SPACE + SET + SPACE + DATA_TYPE + SPACE + this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), quoteIdentifiers, qualifyNames);
        return columnString;
    }

    public String alterTableAlterColumnDefaultValue(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (!(table instanceof BaseTable)) {
            return null;
        }
        String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + this.alterColumnDefaultValueClause(column, quoteIdentifiers, qualifyNames);
        return statement;
    }

    public String alterColumnDefaultValueClause(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String clause = "ALTER COLUMN " + columnName;
        String defaultValue = column.getDefaultValue();
        clause = defaultValue == null || defaultValue.equals(EMPTY_STRING) ? String.valueOf(clause) + " DROP DEFAULT " : String.valueOf(clause) + " SET DEFAULT " + this.getDefaultValue(column);
        return clause;
    }

    public String getUpdateColumnNullValues(Column column, String defaultValue, boolean quoteIdentifiers, boolean qualifyNames) {
        String updateStatement = null;
        String formattedValue = this.formatDefaultValue(column.getContainedType(), defaultValue);
        if (formattedValue != null && !formattedValue.equals(EMPTY_STRING)) {
            String columnName = column.getName();
            String tableName = this.getName(column.getTable(), quoteIdentifiers, qualifyNames);
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            updateStatement = "-- UPDATE " + tableName + SPACE + SET + SPACE + columnName + EQUALS + formattedValue + SPACE + WHERE + SPACE + columnName + SPACE + IS + SPACE + NULL;
        }
        return updateStatement;
    }

    public String alterTableAlterColumnExpression(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            return null;
        }
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " ALTER COLUMN " + columnName;
        ValueExpression v = column.getGenerateExpression();
        statement = v != null && !EMPTY_STRING.equals(v.getSQL()) ? String.valueOf(statement) + " SET EXPRESSION AS " + v.getSQL() : String.valueOf(statement) + " DROP EXPRESSION";
        return statement;
    }

    public String alterTableAlterColumnIdentity(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        return null;
    }

    public String alterTableAlterColumnNullable(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (!(table instanceof BaseTable)) {
            return null;
        }
        String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + this.alterNullableClause(column, quoteIdentifiers, qualifyNames);
        return statement;
    }

    public String alterNullableClause(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String clause = "ALTER COLUMN " + columnName;
        clause = column.isNullable() ? String.valueOf(clause) + " DROP NOT NULL" : String.valueOf(clause) + " SET NOT NULL";
        return clause;
    }

    public String alterTableAlterProperties(Table table, int propertyType, boolean quoteIdentifiers, boolean qualifyNames) {
        return null;
    }

    public String renameTable(Table table, String oldTableName, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName;
        if (table == null) {
            return null;
        }
        String string = schemaName = table.getSchema() != null ? table.getSchema().getName() : "nullschema";
        if (quoteIdentifiers) {
            oldTableName = this.getDoubleQuotedString(oldTableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            oldTableName = String.valueOf(schemaName) + DOT + oldTableName;
        }
        return "RENAME " + oldTableName + SPACE + TO + SPACE + this.getName(table, quoteIdentifiers, false);
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        statement = String.valueOf(statement) + this.getIndexTypePrefix(index);
        statement = String.valueOf(statement) + "INDEX " + this.getName(index, quoteIdentifiers, qualifyNames);
        statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + this.getName(index.getTable(), quoteIdentifiers, qualifyNames);
        statement = String.valueOf(statement) + this.getIndexKeyColumns(index, quoteIdentifiers);
        return statement;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String checkCondition = this.getAddCheckConstraintClause(constraint, quoteIdentifiers, qualifyNames);
        if (checkCondition == null) {
            return null;
        }
        return "ALTER " + this.getOwnerType((TableConstraint)constraint) + SPACE + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + checkCondition;
    }

    public String addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER " + this.getOwnerType((TableConstraint)constraint) + SPACE + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE;
        String uniqueClause = this.getAddUniqueConstraintClause(constraint, quoteIdentifiers, qualifyNames);
        if (uniqueClause == null) {
            return null;
        }
        statement = String.valueOf(statement) + uniqueClause;
        return statement;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
            if (parentKey == null) {
                return null;
            }
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        String statement = "ALTER " + this.getOwnerType((TableConstraint)foreignKey) + SPACE + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + ADD + SPACE + CONSTRAINT + SPACE + this.getName((TableConstraint)foreignKey, quoteIdentifiers, qualifyNames) + SPACE + FOREIGN_KEY;
        statement = String.valueOf(statement) + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers);
        statement = String.valueOf(statement) + NEWLINE + TAB + REFERENCES + SPACE + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames);
        statement = String.valueOf(statement) + parentKey;
        statement = String.valueOf(statement) + this.getDeleteReferentialActionAction(foreignKey);
        statement = String.valueOf(statement) + this.getUpdateReferentialActionAction(foreignKey);
        if (foreignKey.isDeferrable()) {
            statement = String.valueOf(statement) + NEWLINE + TAB + this.getDeferrableClause((Constraint)foreignKey);
        }
        return statement;
    }

    public String createRole(Role role, boolean quoteIdentifiers) {
        String dbName = role.getName();
        if (quoteIdentifiers) {
            dbName = this.getDoubleQuotedString(dbName);
        }
        String statement = "CREATE ROLE " + dbName;
        return statement;
    }

    public String dropRole(Role role, boolean quoteIdentifiers) {
        String dbName = role.getName();
        if (quoteIdentifiers) {
            dbName = this.getDoubleQuotedString(dbName);
        }
        String statement = "DROP ROLE " + dbName;
        return statement;
    }

    public String[] grantOn(Database database, boolean quoteIdentifiers) {
        return this.getGrantString((SQLObject)database, quoteIdentifiers, false);
    }

    public String[] grantOn(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)schema, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)table, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)function, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)procedure, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)sequence, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)index, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(DistinctUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)type, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(Role role, boolean quoteIdentifiers) {
        Vector<String> authVec = new Vector<String>();
        Iterator iter = role.getRoleAuthorization().iterator();
        while (iter.hasNext()) {
            authVec.add(this.getGrantRoleAuthorizationString((RoleAuthorization)iter.next(), quoteIdentifiers));
        }
        Object[] authStr = new String[authVec.size()];
        authVec.copyInto(authStr);
        return authStr;
    }

    public String getGrantRoleAuthorizationStatement(RoleAuthorization roleAuth, boolean quoteIdentifiers) {
        return this.getGrantRoleAuthorizationString(roleAuth, quoteIdentifiers);
    }

    public String[] revokeFrom(Database database, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)database, quoteIdentifiers, false);
    }

    public String[] revokeFrom(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)schema, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)table, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)function, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)procedure, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)sequence, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)index, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(DistinctUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getRevokeString((SQLObject)type, quoteIdentifiers, qualifyNames);
    }

    public String[] revokeFrom(Role role, boolean quoteIdentifiers) {
        Vector<String> authVec = new Vector<String>();
        Iterator iter = role.getRoleAuthorization().iterator();
        while (iter.hasNext()) {
            authVec.add(this.getRevokeRoleAuthorizationString((RoleAuthorization)iter.next(), quoteIdentifiers));
        }
        Object[] authStr = new String[authVec.size()];
        authVec.copyInto(authStr);
        return authStr;
    }

    public String getRevokeRoleAuthorizationStatement(RoleAuthorization roleAuth, boolean quoteIdentifiers) {
        return this.getRevokeRoleAuthorizationString(roleAuth, quoteIdentifiers);
    }

    public String createTableCodetemplate(Table table, int appliedType, boolean isProlog, Map patternMap) {
        if (!patternMap.containsKey("Table")) {
            return null;
        }
        CodeTemplateContextPattern pattern = (CodeTemplateContextPattern)patternMap.get("Table");
        if ((pattern.getAppliedType() & appliedType) != appliedType) {
            return null;
        }
        DatabaseDefinition databaseDefinition = IBMPluginActivator.getInstance().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase(table.getSchema()));
        String terminator = databaseDefinition.getSQLTerminationCharacter();
        if (appliedType == 2) {
            if (isProlog) {
                String prolog = pattern.getCreateProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", table.getSchema().getName());
                    prolog = prolog.replaceAll("\\{table\\}", table.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getCreatePostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", table.getSchema().getName());
                    postlog = postlog.replaceAll("\\{table\\}", table.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        } else if (appliedType == 4) {
            if (isProlog) {
                String prolog = pattern.getDropProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", table.getSchema().getName());
                    prolog = prolog.replaceAll("\\{table\\}", table.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getDropPostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", table.getSchema().getName());
                    postlog = postlog.replaceAll("\\{table\\}", table.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        }
        return null;
    }

    public String createRoutineCodetemplate(Routine routine, int appliedType, boolean isProlog, Map patternMap) {
        if (!patternMap.containsKey("Routine")) {
            return null;
        }
        CodeTemplateContextPattern pattern = (CodeTemplateContextPattern)patternMap.get("Routine");
        if ((pattern.getAppliedType() & appliedType) != appliedType) {
            return null;
        }
        DatabaseDefinition databaseDefinition = IBMPluginActivator.getInstance().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase(routine.getSchema()));
        String terminator = databaseDefinition.getSQLTerminationCharacter();
        if (appliedType == 2) {
            if (isProlog) {
                String prolog = pattern.getCreateProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", routine.getSchema().getName());
                    prolog = prolog.replaceAll("\\{routine\\}", routine.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getCreatePostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", routine.getSchema().getName());
                    postlog = postlog.replaceAll("\\{routine\\}", routine.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        } else if (appliedType == 4) {
            if (isProlog) {
                String prolog = pattern.getDropProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", routine.getSchema().getName());
                    prolog = prolog.replaceAll("\\{routine\\}", routine.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getDropPostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", routine.getSchema().getName());
                    postlog = postlog.replaceAll("\\{routine\\}", routine.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        }
        return null;
    }

    public String createConstraintCodetemplate(TableConstraint constraint, int appliedType, boolean isProlog, Map patternMap) {
        if (!patternMap.containsKey("Constraint")) {
            return null;
        }
        CodeTemplateContextPattern pattern = (CodeTemplateContextPattern)patternMap.get("Constraint");
        if ((pattern.getAppliedType() & appliedType) != appliedType) {
            return null;
        }
        DatabaseDefinition databaseDefinition = IBMPluginActivator.getInstance().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase(constraint.getBaseTable().getSchema()));
        String terminator = databaseDefinition.getSQLTerminationCharacter();
        if (appliedType == 2) {
            if (isProlog) {
                String prolog = pattern.getCreateProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", constraint.getBaseTable().getSchema().getName());
                    prolog = prolog.replaceAll("\\{table\\}", constraint.getBaseTable().getName());
                    prolog = prolog.replaceAll("\\{constraint\\}", constraint.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getCreatePostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", constraint.getBaseTable().getSchema().getName());
                    postlog = postlog.replaceAll("\\{table\\}", constraint.getBaseTable().getName());
                    postlog = postlog.replaceAll("\\{constraint\\}", constraint.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        } else if (appliedType == 4) {
            if (isProlog) {
                String prolog = pattern.getDropProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", constraint.getBaseTable().getSchema().getName());
                    prolog = prolog.replaceAll("\\{table\\}", constraint.getBaseTable().getName());
                    prolog = prolog.replaceAll("\\{constraint\\}", constraint.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getDropPostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", constraint.getBaseTable().getSchema().getName());
                    postlog = postlog.replaceAll("\\{table\\}", constraint.getBaseTable().getName());
                    postlog = postlog.replaceAll("\\{constraint\\}", constraint.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        }
        return null;
    }

    public String createViewCodetemplate(ViewTable view, int appliedType, boolean isProlog, Map patternMap) {
        if (!patternMap.containsKey("View")) {
            return null;
        }
        CodeTemplateContextPattern pattern = (CodeTemplateContextPattern)patternMap.get("View");
        if ((pattern.getAppliedType() & appliedType) != appliedType) {
            return null;
        }
        DatabaseDefinition databaseDefinition = IBMPluginActivator.getInstance().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase(view.getSchema()));
        String terminator = databaseDefinition.getSQLTerminationCharacter();
        if (appliedType == 2) {
            if (isProlog) {
                String prolog = pattern.getCreateProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", view.getSchema().getName());
                    prolog = prolog.replaceAll("\\{view\\}", view.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getCreatePostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", view.getSchema().getName());
                    postlog = postlog.replaceAll("\\{view\\}", view.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        } else if (appliedType == 4) {
            if (isProlog) {
                String prolog = pattern.getDropProlog();
                if (prolog != null) {
                    prolog = prolog.replaceAll("\\{schema\\}", view.getSchema().getName());
                    prolog = prolog.replaceAll("\\{view\\}", view.getName());
                    prolog = prolog.replaceAll("\\{terminator\\}", terminator);
                    return prolog;
                }
            } else {
                String postlog = pattern.getDropPostlog();
                if (postlog != null) {
                    postlog = postlog.replaceAll("\\{schema\\}", view.getSchema().getName());
                    postlog = postlog.replaceAll("\\{view\\}", view.getName());
                    postlog = postlog.replaceAll("\\{terminator\\}", terminator);
                    return postlog;
                }
            }
        }
        return null;
    }

    protected String getDeferrableClause(Constraint constraint) {
        String clause = null;
        if (constraint.isDeferrable()) {
            clause = DEFERRABLE;
            if (constraint.isInitiallyDeferred()) {
                clause = String.valueOf(clause) + " INITIALLY DEFERRED";
            }
        }
        return clause;
    }

    protected String getReferentialAction(ReferentialActionType action) {
        if (action == ReferentialActionType.CASCADE_LITERAL) {
            return CASCADE;
        }
        if (action == ReferentialActionType.RESTRICT_LITERAL) {
            return RESTRICT;
        }
        if (action == ReferentialActionType.SET_DEFAULT_LITERAL) {
            return "SET DEFAULT";
        }
        if (action == ReferentialActionType.SET_NULL_LITERAL) {
            return "SET NULL";
        }
        return EMPTY_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getViewColumnList(ViewTable view, boolean quoteIdentifiers) {
        String columns = null;
        Iterator it = view.getColumns().iterator();
        if (!it.hasNext()) return null;
        Column c = (Column)it.next();
        columns = c.getName();
        if (quoteIdentifiers) {
            columns = this.getDoubleQuotedString(columns);
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            String columnName = c.getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", " + columnName;
        }
        return columns;
    }

    protected String getColumnNameString(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        return columnName;
    }

    protected String getAlterTableAddColumnColumnString(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getColumnString(column, quoteIdentifiers, qualifyNames);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columnString = String.valueOf(columnName) + SPACE + this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), quoteIdentifiers, qualifyNames);
        String defaultValue = this.getDefaultValue(column);
        if (defaultValue != null && !defaultValue.equals(EMPTY_STRING)) {
            columnString = String.valueOf(columnString) + SPACE + DEFAULT + SPACE + defaultValue;
        }
        if (!column.isNullable()) {
            columnString = String.valueOf(columnString) + SPACE + NOT + SPACE + NULL;
        }
        return columnString;
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        return this.getAddUniqueConstraintClause(constraint, quoteIdentifiers, false);
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        String text = "ADD CONSTRAINT " + constraintName + SPACE + this.getUniqueConstraintType(constraint);
        String keyList = this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers);
        if (keyList == null) {
            return null;
        }
        text = String.valueOf(text) + keyList;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getUniqueConstraintType(UniqueConstraint constraint) {
        if (constraint instanceof PrimaryKey) {
            return PRIMARY_KEY;
        }
        return UNIQUE;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        SearchCondition searchCondition = constraint.getSearchCondition();
        if (searchCondition == null) {
            return null;
        }
        String text = "ADD CONSTRAINT " + constraintName + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + searchCondition.getSQL() + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers, false);
        SearchCondition searchCondition = constraint.getSearchCondition();
        if (searchCondition == null) {
            return null;
        }
        String text = "ADD CONSTRAINT " + constraintName + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + searchCondition.getSQL() + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getKeyColumns(ReferenceConstraint constraint, boolean quoteIdentifiers) {
        String columns = String.valueOf(NEWLINE) + TAB + LEFT_PARENTHESIS;
        Iterator it = constraint.getMembers().iterator();
        if (!it.hasNext()) return null;
        Column c = (Column)it.next();
        String colName = c.getName();
        if (quoteIdentifiers) {
            colName = this.getDoubleQuotedString(colName);
        }
        columns = String.valueOf(columns) + colName;
        while (it.hasNext()) {
            c = (Column)it.next();
            colName = c.getName();
            if (quoteIdentifiers) {
                colName = this.getDoubleQuotedString(colName);
            }
            columns = String.valueOf(columns) + COMMA;
            columns = String.valueOf(columns) + NEWLINE + TAB + SPACE + colName;
        }
        return String.valueOf(columns) + RIGHT_PARENTHESIS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        String columns = String.valueOf(NEWLINE) + TAB + LEFT_PARENTHESIS;
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) return null;
        String keyMemberString = null;
        IndexMember m = (IndexMember)it.next();
        Column column = m.getColumn();
        if (column != null) {
            keyMemberString = this.getIndexKeyColumnName(index, column, quoteIdentifiers);
        } else if (m.getExpression() != null) {
            keyMemberString = m.getExpression().getSql();
        }
        columns = String.valueOf(columns) + keyMemberString + this.getIncrementTypeString(m);
        while (it.hasNext()) {
            keyMemberString = null;
            m = (IndexMember)it.next();
            column = m.getColumn();
            if (column != null) {
                keyMemberString = this.getIndexKeyColumnName(index, column, quoteIdentifiers);
            } else if (m.getExpression() != null) {
                keyMemberString = m.getExpression().getSql();
            }
            columns = String.valueOf(columns) + COMMA;
            columns = String.valueOf(columns) + NEWLINE + TAB + SPACE + SPACE + keyMemberString + this.getIncrementTypeString(m);
        }
        return String.valueOf(columns) + RIGHT_PARENTHESIS;
    }

    protected String getIndexKeyColumnName(Index index, Column column, boolean quoteIdentifiers) {
        String keyMemberString = column.getName();
        if (quoteIdentifiers) {
            keyMemberString = this.getDoubleQuotedString(keyMemberString);
        }
        return keyMemberString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getParentKeyColumns(Index index, boolean quoteIdentifiers) {
        String columns = String.valueOf(NEWLINE) + TAB + LEFT_PARENTHESIS;
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) return null;
        IndexMember m = (IndexMember)it.next();
        Column column = m.getColumn();
        if (column == null) return null;
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        columns = String.valueOf(columns) + columnName;
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            column = m.getColumn();
            if (column == null) return null;
            columnName = column.getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns = String.valueOf(columns) + COMMA;
            columns = String.valueOf(columns) + NEWLINE + TAB + SPACE + SPACE + columnName;
        }
        return String.valueOf(columns) + RIGHT_PARENTHESIS;
    }

    protected String getRoutineSpecifier(SQLObject obj, boolean quoteIdentifiers, boolean qualifyNames) {
        Routine routine = (Routine)obj;
        Schema schema = routine.getSchema();
        String name = this.getName(routine, quoteIdentifiers, qualifyNames);
        name = String.valueOf(name) + LEFT_PARENTHESIS;
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter parm = (Parameter)it.next();
            name = String.valueOf(name) + this.getDataTypeString((TypedElement)parm, schema, quoteIdentifiers, qualifyNames) + (it.hasNext() ? COMMA : EMPTY_STRING);
        }
        name = String.valueOf(name) + RIGHT_PARENTHESIS;
        return name;
    }

    public String getParameterString(Parameter parameter, Schema schema, boolean qualifyNames) {
        return this.getDataTypeString((TypedElement)parameter, schema, qualifyNames);
    }

    public String getRowDataTypeFields(DataType type) {
        return null;
    }

    public String getObjectDataTypeString(TypedElement typedElement) {
        return this.getDataTypeStringIgnoreDomain(typedElement, null, true, null);
    }

    public String getObjectDataTypeString(TypedElement typedElement, SQLDataType type) {
        return this.getDataTypeStringIgnoreDomain(typedElement, null, true, type);
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean qualifyNames) {
        return this.getDataTypeStringIgnoreDomain(typedElement, schema, qualifyNames, null);
    }

    private String getDataTypeStringIgnoreDomain(TypedElement typedElement, Schema schema, boolean qualifyNames, SQLDataType type) {
        SQLDataType containedType = null;
        containedType = type != null ? type : typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return String.valueOf(def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType)) + this.getCharacterSetString(containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema || qualifyNames) {
                    return this.getName(referencedType, false, true);
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return String.valueOf(def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType)) + this.getCharacterSetString(containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema || qualifyNames) {
                    return this.getName(referencedType, quoteIdentifiers, true);
                }
                return this.getName(referencedType, quoteIdentifiers, false);
            }
        }
        return null;
    }

    public String getPredefinedTypeCharacterSetString(PredefinedDataType type) {
        return this.getCharacterSetString((SQLDataType)type);
    }

    protected String getCharacterSetString(SQLDataType type) {
        return EMPTY_STRING;
    }

    protected String getDomainTypeString(TypedElement typedElement, Schema schema, boolean qualifyNames) {
        TypedElementLogicalDomainProvider elementDomainProvider = DdlGenerationUtility.getElementDomainProvider();
        if (elementDomainProvider != null && elementDomainProvider.hasDomain(typedElement)) {
            String domainType = elementDomainProvider.getDomainBaseType(typedElement);
            if (EMPTY_STRING.equals(domainType)) {
                return null;
            }
            return domainType;
        }
        return null;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getName(constraint, quoteIdentifiers);
    }

    protected String getTableConstraintName(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = constraint.getName();
        String tableName = constraint.getBaseTable().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            tableName = this.getDoubleQuotedString(tableName);
        }
        if (qualifyNames) {
            name = String.valueOf(tableName) + DOT + name;
        }
        return name;
    }

    protected String getName(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = column.getName();
        String tableName = column.getTable().getName();
        String schemaName = column.getTable().getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + DOT + tableName + DOT + name;
        }
        return name;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        Schema schema = trigger.getSchema() == null ? trigger.getSubjectTable().getSchema() : trigger.getSchema();
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + DOT + name;
        }
        return name;
    }

    protected String getName(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = routine.getName();
        String schemaName = routine.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + DOT + name;
        }
        return name;
    }

    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = index.getTable();
        String indexName = index.getName();
        Schema schema = index.getSchema();
        if (schema == null) {
            schema = table.getSchema();
        }
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            indexName = this.getDoubleQuotedString(indexName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            indexName = String.valueOf(schemaName) + DOT + indexName;
        }
        return indexName;
    }

    protected String getName(Database database, boolean quoteIdentifiers) {
        String name = database.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(AuthorizationIdentifier auth, boolean quoteIdentifiers) {
        String name = auth.getName();
        if (quoteIdentifiers && !name.equals("PUBLIC")) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        return schemaName;
    }

    protected String getName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName;
        String tableName = table.getName();
        String string = schemaName = table.getSchema() != null ? table.getSchema().getName() : "nullschema";
        if (table.getSchema() == null) {
            IBMPluginActivator.getInstance().writeLog(4, 0, "Table " + tableName + " does not have a schema. The table name will be qualified with \"nullschema\" in the DDL for now.", null);
        }
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + DOT + tableName;
        }
        return tableName;
    }

    protected String getName(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName;
        String sequenceName = sequence.getName();
        String string = schemaName = sequence.getSchema() != null ? sequence.getSchema().getName() : null;
        if (schemaName == null) {
            IBMPluginActivator.getInstance().writeLog(4, 0, "Sequence " + sequence + " does not have a schema. The sequence name will not be qualified in the DDL.", null);
        }
        if (quoteIdentifiers) {
            sequenceName = this.getDoubleQuotedString(sequenceName);
            if (schemaName != null) {
                schemaName = this.getDoubleQuotedString(schemaName);
            }
        }
        if (qualifyNames && schemaName != null) {
            sequenceName = String.valueOf(schemaName) + DOT + sequenceName;
        }
        return sequenceName;
    }

    protected String getName(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName;
        String typeName = type.getName();
        String string = schemaName = type.getSchema() != null ? type.getSchema().getName() : null;
        if (schemaName == null) {
            IBMPluginActivator.getInstance().writeLog(4, 0, "User-defined type " + type + " does not have a schema. The user-defined type name will not be qualified in the DDL.", null);
        }
        if (quoteIdentifiers) {
            typeName = this.getDoubleQuotedString(typeName);
            if (schemaName != null) {
                schemaName = this.getDoubleQuotedString(schemaName);
            }
        }
        if (qualifyNames && schemaName != null) {
            typeName = String.valueOf(schemaName) + DOT + typeName;
        }
        return typeName;
    }

    protected String ensureSingleQuotedString(String original) {
        if (original == null) {
            return null;
        }
        if (original.startsWith(SINGLE_QUOTE) && original.endsWith(SINGLE_QUOTE)) {
            return original;
        }
        return this.getSingleQuotedString(original);
    }

    protected String getSingleQuotedString(String orignal) {
        String result = orignal;
        if (orignal.startsWith(SINGLE_QUOTE) && orignal.endsWith(SINGLE_QUOTE)) {
            result = orignal.substring(1, orignal.length() - 1);
        }
        result = result.replaceAll(SINGLE_QUOTE, "''");
        return SINGLE_QUOTE + result + SINGLE_QUOTE;
    }

    protected String getDoubleQuotedString(String orignal) {
        String result = orignal = orignal.replaceAll(DOUBLE_QUOTE, "\"\"");
        return DOUBLE_QUOTE + result + DOUBLE_QUOTE;
    }

    public static String makeCharacterConstant(String constant) {
        StringBuffer work = new StringBuffer(constant);
        int pos = 0;
        while ((pos = work.indexOf(SINGLE_QUOTE, pos)) >= 0) {
            work.insert(pos, '\'');
            pos += 2;
        }
        work.insert(0, '\'');
        work.append('\'');
        return work.toString();
    }

    protected String getOwnerType(TableConstraint constraint) {
        return TABLE;
    }

    public static RoutineDdlBuilder getRoutineDdlBuilder(String dbProduct, String dbVersion) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "routineDdlBuilder");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String version;
                    String product;
                    if (configElements[j].getName().equals("builder") && (product = configElements[j].getAttribute("product")).equals(dbProduct) && (version = configElements[j].getAttribute("version")).equals(dbVersion)) {
                        try {
                            routineDdlBuilder = (RoutineDdlBuilder)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the routine ddl builder for " + product + SPACE + version, (Throwable)e);
                            IBMPluginActivator.getInstance().getLog().log((IStatus)status);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return routineDdlBuilder;
    }

    public boolean isImplicitPK(TableConstraint constraint) {
        return constraint instanceof PrimaryKey && !constraint.isEnforced();
    }

    protected String getDefaultValue(Column column) {
        String defaultValue = column.getDefaultValue();
        SQLDataType type = column.getContainedType();
        return this.formatDefaultValue(type, defaultValue);
    }

    protected String formatDefaultValue(SQLDataType type, String defaultValue) {
        if (defaultValue == null || defaultValue.equals(EMPTY_STRING)) {
            return null;
        }
        if (type == null) {
            return null;
        }
        if (type instanceof CharacterStringDataType || type instanceof DateDataType || type instanceof TimeDataType) {
            return this.getSingleQuotedString(defaultValue);
        }
        return defaultValue;
    }

    protected String[] getGrantString(SQLObject sqlObject, boolean quoteIdentifiers, boolean qualifyNames) {
        Vector<String> grantVec = new Vector<String>();
        for (Privilege privilege : sqlObject.getPrivileges()) {
            String statement = this.getGrantPrivilegeStatement(privilege, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            grantVec.add(this.getGrantPrivilegeStatement(privilege, quoteIdentifiers, qualifyNames));
        }
        Object[] grantStr = new String[grantVec.size()];
        grantVec.copyInto(grantStr);
        return grantStr;
    }

    protected String[] getRevokeString(SQLObject sqlObject, boolean quoteIdentifiers, boolean qualifyNames) {
        Vector<String> revokeVec = new Vector<String>();
        for (Privilege privilege : sqlObject.getPrivileges()) {
            String statement = this.getGrantPrivilegeStatement(privilege, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            revokeVec.add(this.getRevokePrivilegeStatement(privilege, quoteIdentifiers, qualifyNames));
        }
        Object[] revokeStr = new String[revokeVec.size()];
        revokeVec.copyInto(revokeStr);
        return revokeStr;
    }

    public String getGrantPrivilegeStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        if (this.isDDLSupressable(privilege)) {
            return null;
        }
        String ret = "GRANT " + privilege.getAction() + SPACE + ON + SPACE + this.getPrivilegedObjectTypeString(privilege) + SPACE + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + SPACE + TO + SPACE + this.getGranteeSubstring(privilege.getGrantee(), quoteIdentifiers);
        if (privilege.isGrantable()) {
            ret = String.valueOf(ret) + " WITH GRANT OPTION";
        }
        return ret;
    }

    public String getRevokePrivilegeStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        if (this.isDDLSupressable(privilege)) {
            return null;
        }
        String ret = "REVOKE " + privilege.getAction() + SPACE + ON + SPACE + this.getPrivilegedObjectTypeString(privilege) + SPACE + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + SPACE + FROM + SPACE + this.getGranteeSubstring(privilege.getGrantee(), quoteIdentifiers);
        return ret;
    }

    protected String getGranteeSubstring(AuthorizationIdentifier authId, boolean quoteIdentifiers) {
        return this.getName(authId, quoteIdentifiers);
    }

    protected String getPrivilegedObjectName(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        SQLObject obj = privilege.getObject();
        String name = null;
        if (obj instanceof Table) {
            name = this.getName((Table)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Index) {
            name = this.getName((Index)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Sequence) {
            name = this.getName((Sequence)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Schema) {
            name = this.getName((Schema)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Routine) {
            name = this.getName((Routine)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof UserDefinedType) {
            name = this.getName((UserDefinedType)obj, quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Database) {
            name = EMPTY_STRING;
        }
        return name;
    }

    protected String getPrivilegedObjectTypeString(Privilege privilege) {
        SQLObject obj = privilege.getObject();
        if (obj instanceof BaseTable) {
            return TABLE;
        }
        if (obj instanceof ViewTable) {
            return TABLE;
        }
        if (obj instanceof Index) {
            return INDEX;
        }
        if (obj instanceof Schema) {
            return SCHEMA;
        }
        if (obj instanceof Sequence) {
            return SEQUENCE;
        }
        if (obj instanceof UserDefinedType) {
            return TYPE;
        }
        if (obj instanceof Database) {
            return DATABASE;
        }
        return EMPTY_STRING;
    }

    protected String getGrantRoleAuthorizationString(RoleAuthorization roleAuth, boolean quoteIdentifiers) {
        String authStr = String.valueOf(NEWLINE) + GRANT + SPACE + this.getName((AuthorizationIdentifier)roleAuth.getRole(), quoteIdentifiers) + SPACE + TO + this.getGranteeType(roleAuth.getGrantee()) + SPACE + this.getName(roleAuth.getGrantee(), quoteIdentifiers);
        if (roleAuth.isGrantable()) {
            authStr = String.valueOf(authStr) + " WITH GRANT OPTION";
        }
        return authStr;
    }

    protected String getRevokeRoleAuthorizationString(RoleAuthorization roleAuth, boolean quoteIdentifiers) {
        String authStr = String.valueOf(NEWLINE) + REVOKE + SPACE + this.getName((AuthorizationIdentifier)roleAuth.getRole(), quoteIdentifiers) + SPACE + FROM + this.getGranteeType(roleAuth.getGrantee()) + SPACE + this.getName(roleAuth.getGrantee(), quoteIdentifiers);
        return authStr;
    }

    protected String getGranteeType(AuthorizationIdentifier authID) {
        return EMPTY_STRING;
    }

    protected String getIndexTypePrefix(Index index) {
        if (index.isUnique()) {
            return "UNIQUE ";
        }
        return EMPTY_STRING;
    }

    private IEngineeringCallBack getDummyEngineeringCallBack() {
        if (this.dummyCallback == null) {
            this.dummyCallback = new dummyEngineeringCallBack();
        }
        return this.dummyCallback;
    }

    protected boolean isDDLSupressable(Privilege privilege) {
        return AccessControlUtilities.isDDLSuppressable(privilege);
    }

    protected String getDeleteReferentialActionAction(ForeignKey foreignKey) {
        String statement = EMPTY_STRING;
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + DELETE + SPACE + this.getReferentialAction(action);
        }
        return statement;
    }

    protected String getUpdateReferentialActionAction(ForeignKey foreignKey) {
        String statement = EMPTY_STRING;
        ReferentialActionType action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + UPDATE + SPACE + this.getReferentialAction(action);
        }
        return statement;
    }

    protected String getIncrementTypeString(IndexMember m) {
        return "\t\t" + m.getIncrementType().getName();
    }

    protected String getSystemGrantMessage(String action, Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer msg = new StringBuffer();
        if (action.equals(GRANT)) {
            msg.append(DdlGenerationMessages.GRANT_NOT_ALLOWED);
        }
        if (action.equals(REVOKE)) {
            msg.append(DdlGenerationMessages.REVOKE_NOT_ALLOWED);
        }
        if (msg.length() == 0) {
            return null;
        }
        msg.append(": ");
        msg.append(privilege.getAction());
        msg.append(" ON ");
        msg.append(this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames));
        return msg.toString();
    }

    protected String getAttrString(AttributeDefinition attr, Schema schema, boolean qualifyNames) {
        String typeName = this.getDataTypeString((TypedElement)attr, schema, qualifyNames);
        String statement = String.valueOf(attr.getName()) + SPACE + typeName;
        return statement;
    }

    public String getAttrString(AttributeDefinition attr, Schema schema) {
        return this.getAttrString(attr, schema, false);
    }

    protected String getNameQualifiedWithSchema(String ddlSource, Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        Schema schema = routine.getSchema();
        String name = routine.getName();
        if (ddlSource == null || ddlSource.trim().isEmpty() || !(routine instanceof ICatalogObject) || schema == null || schema.getName() == null || schema.getName().trim().isEmpty() || name == null || name.trim().isEmpty()) {
            return ddlSource;
        }
        String result = ddlSource;
        if (qualifyNames) {
            String upperCasePretext;
            String pretext;
            String schemaName = schema.getName();
            String quotedSchemaName = this.getDoubleQuotedString(schemaName);
            String quotedName = this.getDoubleQuotedString(name);
            String upperCaseDdlSource = ddlSource.toUpperCase();
            String upperCaseName = name.toUpperCase();
            String upperCaseSchemaName = schemaName.toUpperCase();
            String usedName = quotedName;
            int nameIndex = ddlSource.indexOf(quotedName);
            if (nameIndex == -1 && (nameIndex = upperCaseDdlSource.indexOf(upperCaseName)) != -1) {
                usedName = ddlSource.substring(nameIndex, nameIndex + name.length());
            }
            if (nameIndex > 0 && (pretext = ddlSource.substring(0, nameIndex)).indexOf(quotedSchemaName) == -1 && (upperCasePretext = pretext.toUpperCase()).indexOf(upperCaseSchemaName) == -1) {
                result = quoteIdentifiers ? ddlSource.replaceFirst(usedName, String.valueOf(quotedSchemaName) + DOT + quotedName) : ddlSource.replaceFirst(usedName, String.valueOf(schemaName) + DOT + name);
            }
        }
        return result;
    }

    public String getFullParameterString(Routine routine) {
        EList parms = routine.getParameters();
        StringBuffer buf = new StringBuffer();
        if (!parms.isEmpty()) {
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                buf.append(LEFT_PARENTHESIS);
                Parameter parm = (Parameter)it.next();
                buf.append(parm.getMode());
                buf.append(SPACE);
                buf.append(parm.getName());
                buf.append(SPACE);
                buf.append(this.getParameterString(parm, routine.getSchema(), false));
                buf.append(RIGHT_PARENTHESIS);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
        }
        String result = buf.toString();
        return result;
    }

    public class dummyEngineeringCallBack
    implements IEngineeringCallBack {
        public String[] getMessages() {
            return new String[0];
        }

        public void writeMessage(String message) {
        }
    }
}

