/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumnAnnotation2_0;

public final class SourceOrderColumnAnnotation2_0
extends SourceNamedColumnAnnotation
implements OrderColumnAnnotation2_0 {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    private DeclarationAnnotationElementAdapter<Boolean> nullableDeclarationAdapter = this.buildNullableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> nullableAdapter = this.buildNullableAdapter();
    private Boolean nullable;
    private TextRange nullableTextRange;
    private DeclarationAnnotationElementAdapter<Boolean> insertableDeclarationAdapter = this.buildInsertableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> insertableAdapter = this.buildInsertableAdapter();
    private Boolean insertable;
    private TextRange insertableTextRange;
    private DeclarationAnnotationElementAdapter<Boolean> updatableDeclarationAdapter = this.buildUpdatableDeclarationAdapter();
    private AnnotationElementAdapter<Boolean> updatableAdapter = this.buildUpdatableAdapter();
    private Boolean updatable;
    private TextRange updatableTextRange;

    public SourceOrderColumnAnnotation2_0(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceModel)parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.nullable = this.buildNullable(astAnnotation);
        this.nullableTextRange = this.buildNullableTextRange(astAnnotation);
        this.insertable = this.buildInsertable(astAnnotation);
        this.insertableTextRange = this.buildInsertableTextRange(astAnnotation);
        this.updatable = this.buildUpdatable(astAnnotation);
        this.updatableTextRange = this.buildUpdatableTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncNullable(this.buildNullable(astAnnotation));
        this.nullableTextRange = this.buildNullableTextRange(astAnnotation);
        this.syncInsertable(this.buildInsertable(astAnnotation));
        this.insertableTextRange = this.buildInsertableTextRange(astAnnotation);
        this.syncUpdatable(this.buildUpdatable(astAnnotation));
        this.updatableTextRange = this.buildUpdatableTextRange(astAnnotation);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public Boolean getNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(Boolean nullable) {
        if (ObjectTools.notEquals((Object)this.nullable, (Object)nullable)) {
            this.nullable = nullable;
            this.nullableAdapter.setValue((Object)nullable);
        }
    }

    private void syncNullable(Boolean astNullable) {
        Boolean old = this.nullable;
        this.nullable = astNullable;
        this.firePropertyChanged("nullable", old, astNullable);
    }

    private Boolean buildNullable(Annotation astAnnotation) {
        return (Boolean)this.nullableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNullableTextRange() {
        return this.nullableTextRange;
    }

    private TextRange buildNullableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nullableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildNullableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getNullableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildNullableAdapter() {
        return this.buildBooleanElementAdapter(this.nullableDeclarationAdapter);
    }

    String getNullableElementName() {
        return "nullable";
    }

    @Override
    public Boolean getInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(Boolean insertable) {
        if (ObjectTools.notEquals((Object)this.insertable, (Object)insertable)) {
            this.insertable = insertable;
            this.insertableAdapter.setValue((Object)insertable);
        }
    }

    private void syncInsertable(Boolean astInsertable) {
        Boolean old = this.insertable;
        this.insertable = astInsertable;
        this.firePropertyChanged("insertable", old, astInsertable);
    }

    private Boolean buildInsertable(Annotation astAnnotation) {
        return (Boolean)this.insertableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getInsertableTextRange() {
        return this.insertableTextRange;
    }

    private TextRange buildInsertableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.insertableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildInsertableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getInsertableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildInsertableAdapter() {
        return this.buildBooleanElementAdapter(this.insertableDeclarationAdapter);
    }

    String getInsertableElementName() {
        return "insertable";
    }

    @Override
    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(Boolean updatable) {
        if (ObjectTools.notEquals((Object)this.updatable, (Object)updatable)) {
            this.updatable = updatable;
            this.updatableAdapter.setValue((Object)updatable);
        }
    }

    private void syncUpdatable(Boolean astUpdatable) {
        Boolean old = this.updatable;
        this.updatable = astUpdatable;
        this.firePropertyChanged("updatable", old, astUpdatable);
    }

    private Boolean buildUpdatable(Annotation astAnnotation) {
        return (Boolean)this.updatableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getUpdatableTextRange() {
        return this.updatableTextRange;
    }

    private TextRange buildUpdatableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.updatableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUpdatableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUpdatableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUpdatableAdapter() {
        return this.buildBooleanElementAdapter(this.updatableDeclarationAdapter);
    }

    String getUpdatableElementName() {
        return "updatable";
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.nullable == null && this.insertable == null && this.updatable == null;
    }
}

