/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.ICommonManifestUIConstants;
import org.eclipse.jst.j2ee.internal.WebLibDependencyPropertiesPage;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.dialogs.DependencyConflictResolveDialog;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJarsProvider;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClasspathTableManager
implements Listener,
ICommonManifestUIConstants {
    protected Button useClientJARsBtn;
    protected Button useServerJARsBtn;
    protected Button useAnyJARsBtn;
    protected Button upButton;
    protected Button downButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected IClasspathTableOwner owner;
    protected Composite buttonColumn;
    protected ClasspathModel model;
    protected CheckboxTableViewer availableJARsViewer;
    protected IValidateEditListener validateEditListener;
    protected boolean isWLPEntry;
    protected Group radioGroup;
    protected boolean readOnly;
    protected AvailableJarsProvider availableJarsProvider;
    protected Button externalJarButton;
    protected Button projectJarButton;
    protected Button addVariableButton;
    protected Set compsToUncheck = new HashSet();

    public ClasspathTableManager(IClasspathTableOwner owner, ClasspathModel model) {
        this(owner, model, null);
    }

    public ClasspathTableManager(IClasspathTableOwner owner, ClasspathModel model, IValidateEditListener listener) {
        this.owner = owner;
        this.model = model;
        this.validateEditListener = listener;
    }

    public void fillComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createRadioGroup(parent);
        this.createTable(parent);
        this.createButtonColumn(parent);
    }

    public void fillWLPComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createWLPButtonColumn(parent);
    }

    public void fillWebRefComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createWebRefButtonColumn(parent);
    }

    private void initializeEJBClientDefaults() {
        if (this.model == null || this.model.getClassPathSelection() == null) {
            return;
        }
        boolean shouldUseServerJARs = false;
        ClassPathSelection selection = this.model.getClassPathSelection();
        boolean ejbSelected = selection.isAnyEJBJarSelected();
        boolean clientSelected = selection.isAnyEJBClientJARSelected();
        int filterLevel = ejbSelected && clientSelected ? 2 : (shouldUseServerJARs ? (clientSelected ? 2 : 1) : (ejbSelected ? 2 : 0));
        this.initFilterLevel(filterLevel);
    }

    private void initFilterLevel(int filterLevel) {
        this.model.getClassPathSelection().setFilterLevel(filterLevel);
        switch (filterLevel) {
            case 2: {
                this.useAnyJARsBtn.setSelection(true);
                this.useClientJARsBtn.setSelection(false);
                this.useServerJARsBtn.setSelection(false);
                break;
            }
            case 1: {
                this.useAnyJARsBtn.setSelection(false);
                this.useClientJARsBtn.setSelection(false);
                this.useServerJARsBtn.setSelection(true);
                break;
            }
            case 0: {
                this.useAnyJARsBtn.setSelection(false);
                this.useClientJARsBtn.setSelection(true);
                this.useServerJARsBtn.setSelection(false);
            }
        }
    }

    private void createRadioGroup(Composite parent) {
        this.radioGroup = this.owner.createGroup(parent);
        this.radioGroup.setText(EJB_CLIENT_RADIO_UI_);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        GridLayout layout = new GridLayout(3, false);
        this.radioGroup.setLayout((Layout)layout);
        this.radioGroup.setLayoutData((Object)data);
        this.useServerJARsBtn = this.createRadioButton(USE_EJB_SERVER_JARs_UI_, (Composite)this.radioGroup);
        this.useClientJARsBtn = this.createRadioButton(USE_EJB_CLIENT_JARs_UI_, (Composite)this.radioGroup);
        this.useAnyJARsBtn = this.createRadioButton(USE_BOTH_UI_, (Composite)this.radioGroup);
        this.initializeEJBClientDefaults();
    }

    protected void createButtonColumn(Composite parent) {
        this.buttonColumn = this.owner.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createPushButtons();
    }

    protected void createWLPButtonColumn(Composite parent) {
        this.buttonColumn = this.owner.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createWLPPushButtons();
    }

    protected void createWebRefButtonColumn(Composite parent) {
        this.buttonColumn = this.owner.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createWebRefPushButtons();
    }

    protected void createTable(Composite parent) {
        this.availableJARsViewer = this.owner.createAvailableJARsViewer(parent);
        GridData gd = new GridData(1296);
        this.availableJARsViewer.getTable().setLayoutData((Object)gd);
        this.availableJarsProvider = new AvailableJarsProvider();
        this.availableJARsViewer.setContentProvider((IContentProvider)this.availableJarsProvider);
        this.availableJARsViewer.setLabelProvider((IBaseLabelProvider)this.availableJarsProvider);
        this.addTableListeners();
    }

    protected void createWLPPushButtons() {
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        this.projectJarButton = this.createPushButton(J2EEUIMessages.getResourceString("PROJECT_JAR"));
        this.externalJarButton = this.createPushButton(J2EEUIMessages.getResourceString("EXTERNAL_JAR"));
        this.addVariableButton = this.createPushButton(J2EEUIMessages.getResourceString("ADDVARIABLE"));
        if (this.isReadOnly()) {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
            this.projectJarButton.setEnabled(false);
            this.externalJarButton.setEnabled(false);
            this.addVariableButton.setEnabled(false);
        }
    }

    protected void createWebRefPushButtons() {
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        if (this.isReadOnly()) {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    protected void createPushButtons() {
        this.upButton = this.createPushButton(UP_BUTTON);
        this.downButton = this.createPushButton(DOWN_BUTTON);
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        if (this.isReadOnly()) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    protected void createWebLibPushButtons() {
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        this.projectJarButton = this.createPushButton(J2EEUIMessages.getResourceString("PROJECT_JAR"));
        this.externalJarButton = this.createPushButton(J2EEUIMessages.getResourceString("EXTERNAL_JAR"));
        this.addVariableButton = this.createPushButton(J2EEUIMessages.getResourceString("ADDVARIABLE"));
        if (this.isReadOnly()) {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    protected Button createPushButton(String label) {
        Button aButton = this.owner.primCreatePushButton(label, this.buttonColumn);
        aButton.addListener(13, (Listener)this);
        aButton.setLayoutData((Object)new GridData(768));
        return aButton;
    }

    protected Button createRadioButton(String label, Composite parent) {
        Button aButton = this.owner.primCreateRadioButton(label, parent);
        aButton.addListener(13, (Listener)this);
        return aButton;
    }

    public void handleEvent(Event event) {
        ClasspathModelEvent evt = new ClasspathModelEvent(1);
        this.model.fireNotification(evt);
        if (event.widget == this.upButton) {
            this.upButtonSelected();
        } else if (event.widget == this.downButton) {
            this.downButtonSelected();
        } else if (event.widget == this.selectAllButton) {
            this.selectAllButtonSelected();
        } else if (event.widget == this.deselectAllButton) {
            this.deselectAllButtonSelected();
        } else if (event.widget == this.useServerJARsBtn) {
            this.handleServerJARsButtonSelected();
        } else if (event.widget == this.useClientJARsBtn) {
            this.handleClientJARsButtonSelected();
        } else if (event.widget == this.useAnyJARsBtn) {
            this.handleAnyJARsButtonSelected();
        } else if (event.widget == this.projectJarButton) {
            this.handleSelectProjectJarButton();
        } else if (event.widget == this.externalJarButton) {
            this.handleSelectExternalJarButton();
        } else if (event.widget == this.addVariableButton) {
            this.handleSelectVariableButton();
        }
    }

    private void handleSelectExternalJarButton() {
        if (this.owner instanceof WebLibDependencyPropertiesPage) {
            WebLibDependencyPropertiesPage control = (WebLibDependencyPropertiesPage)this.owner;
            control.handleSelectExternalJarButton();
        }
    }

    private void handleSelectProjectJarButton() {
        if (this.owner instanceof WebLibDependencyPropertiesPage) {
            WebLibDependencyPropertiesPage control = (WebLibDependencyPropertiesPage)this.owner;
            control.handleSelectProjectJarButton();
        }
    }

    private void handleSelectVariableButton() {
        if (this.owner instanceof WebLibDependencyPropertiesPage) {
            WebLibDependencyPropertiesPage control = (WebLibDependencyPropertiesPage)this.owner;
            control.handleSelectVariableButton();
        }
    }

    private void handleServerJARsButtonSelected() {
        this.model.selectFilterLevel(1);
        this.refresh();
    }

    private void handleClientJARsButtonSelected() {
        this.model.selectFilterLevel(0);
        this.refresh();
    }

    private void handleAnyJARsButtonSelected() {
        this.model.selectFilterLevel(2);
        this.refresh();
    }

    public boolean validatateEdit() {
        return this.validateEditListener.validateState().isOK();
    }

    protected void deselectAllButtonSelected() {
        if (!this.validatateEdit()) {
            return;
        }
        this.availableJARsViewer.setAllChecked(false);
        this.model.setAllClasspathElementsSelected(false);
        this.compsToUncheck.clear();
    }

    protected void selectAllButtonSelected() {
        if (!this.validatateEdit()) {
            return;
        }
        this.availableJARsViewer.setAllChecked(true);
        Object[] elements = this.availableJARsViewer.getCheckedElements();
        this.model.setAllClasspathElementsSelected(Arrays.asList(elements), true);
        int i = 0;
        while (i < elements.length) {
            IVirtualComponent comp;
            ClasspathElement el = (ClasspathElement)elements[i];
            el.getComponent().getAdapter(IVirtualComponent.class);
            IVirtualComponent ar = el.getTargetComponent();
            IVirtualComponent iVirtualComponent = comp = ar instanceof J2EEModuleVirtualArchiveComponent ? ar : el.getComponent();
            if (this.isLibrary(comp)) {
                this.compsToUncheck.add(comp);
            }
            ++i;
        }
    }

    protected List getSelectionAsList() {
        return ((IStructuredSelection)this.availableJARsViewer.getSelection()).toList();
    }

    protected List getCheckedLibsAsList() {
        LinkedList<IVirtualComponent> res = new LinkedList<IVirtualComponent>();
        for (IVirtualComponent comp : this.compsToUncheck) {
            res.add(comp);
        }
        return res;
    }

    protected void downButtonSelected() {
        if (!this.validatateEdit()) {
            return;
        }
        this.model.moveDown(this.getSelectionAsList());
        this.refresh();
    }

    protected void upButtonSelected() {
        if (!this.validatateEdit()) {
            return;
        }
        this.model.moveUp(this.getSelectionAsList());
        this.refresh();
    }

    protected void updateButtonEnablements() {
        int[] indices = this.availableJARsViewer.getTable().getSelectionIndices();
        if (this.upButton != null && this.downButton != null) {
            this.upButton.setEnabled(this.canMoveUp(indices));
            this.downButton.setEnabled(this.canMoveDown(indices, this.availableJARsViewer.getTable().getItemCount()));
        }
    }

    protected boolean canMoveUp(int[] indices) {
        return this.canMove(indices, 0);
    }

    protected boolean canMoveDown(int[] indices, int itemCount) {
        return this.canMove(indices, itemCount - 1);
    }

    protected boolean canMove(int[] indices, int referenceIndex) {
        int length = indices.length;
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (indices[i] == referenceIndex) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void addTableListeners() {
        this.addCheckStateListener();
        this.addSelectionListener();
    }

    protected void addCheckStateListener() {
        this.availableJARsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ClasspathTableManager.this.availableJARCheckStateChanged(event);
            }
        });
    }

    private boolean isLibrary(IVirtualComponent component) {
        if (JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
            return false;
        }
        if (JavaEEProjectUtilities.isEARProject((IProject)component.getProject()) && component.isBinary()) {
            return true;
        }
        if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
            return false;
        }
        if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
            return false;
        }
        if (JavaEEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
            return false;
        }
        if (JavaEEProjectUtilities.isStaticWebProject((IProject)component.getProject())) {
            return false;
        }
        if (JavaEEProjectUtilities.isProjectOfType((IProject)component.getProject(), (String)"jst.java")) {
            return true;
        }
        return true;
    }

    protected void availableJARCheckStateChanged(CheckStateChangedEvent event) {
        ClasspathElement el = (ClasspathElement)event.getElement();
        if (el.getComponent() == null) {
            ClasspathElement element = (ClasspathElement)event.getElement();
            this.model.setSelection(element, event.getChecked());
            return;
        }
        el.getComponent().getAdapter(IVirtualComponent.class);
        IVirtualComponent ar = el.getTargetComponent();
        IVirtualComponent comp = ar instanceof J2EEModuleVirtualArchiveComponent ? ar : el.getComponent();
        CheckboxTableViewer v = (CheckboxTableViewer)event.getSource();
        if (this.isLibrary(comp) && event.getChecked()) {
            DependencyConflictResolveDialog dlg;
            if (this.isConflict(comp) && (dlg = new DependencyConflictResolveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).open() == 1) {
                v.setChecked((Object)el, false);
                return;
            }
            this.compsToUncheck.add(comp);
        } else if (!event.getChecked()) {
            this.compsToUncheck.remove(comp);
        }
        if (!EarUtilities.isStandaloneProject((IProject)this.model.getComponent().getProject()) && (this.isReadOnly() || !this.validatateEdit() || this.isMyClientJAR(event) && !event.getChecked())) {
            this.availableJARsViewer.setChecked(event.getElement(), !event.getChecked());
            return;
        }
        ClasspathElement element = (ClasspathElement)event.getElement();
        this.model.setSelection(element, event.getChecked());
    }

    private boolean isConflict(IVirtualComponent lib) {
        IProject[] ears = EarUtilities.getReferencingEARProjects((IProject)lib.getProject());
        int i = 0;
        while (i < ears.length) {
            if (J2EEProjectUtilities.isJEEProject((IProject)ears[i])) {
                IVirtualComponent cmp = ComponentCore.createComponent((IProject)ears[i]);
                IVirtualReference[] refs = cmp.getReferences();
                int j = 0;
                while (j < refs.length) {
                    IVirtualReference ref;
                    if (this.model.getProject().equals((Object)refs[j].getReferencedComponent().getProject()) && (ref = cmp.getReference(lib.getName())) != null && !ref.getRuntimePath().isRoot()) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isMyClientJAR(CheckStateChangedEvent event) {
        ClasspathElement element = (ClasspathElement)event.getElement();
        if (this.getClasspathSelection() != null) {
            return this.getClasspathSelection().isMyClientJAR(element);
        }
        return false;
    }

    protected void addSelectionListener() {
        this.availableJARsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ClasspathTableManager.this.tableSelectionChanged();
            }
        });
    }

    protected void tableSelectionChanged() {
        if (!this.isReadOnly()) {
            this.updateButtonEnablements();
        }
    }

    protected ClassPathSelection getClasspathSelection() {
        if (this.model == null || this.model.getSelectedEARComponent() == null && !EarUtilities.isStandaloneProject((IProject)this.model.getComponent().getProject())) {
            return null;
        }
        return this.model.getClassPathSelection();
    }

    public void refreshCheckedItems() {
        if (this.getClasspathSelection() == null) {
            return;
        }
        List elements = this.getClasspathSelection().getClasspathElements();
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement element = (ClasspathElement)elements.get(i);
            this.availableJARsViewer.setChecked((Object)element, element.isSelected());
            if (element.isClasspathDependency()) {
                this.availableJARsViewer.setGrayed((Object)element, true);
            }
            ++i;
        }
    }

    public void refresh() {
        IProject project = this.model.getComponent().getProject();
        if (!(this.isWLPEntry() || EarUtilities.isStandaloneProject((IProject)project) && J2EEProjectUtilities.getReferencingWebProjects((IProject)project).length <= 0)) {
            this.availableJARsViewer.setInput((Object)this.getClasspathSelection());
            GridData data = new GridData(1808);
            int numlines = Math.min(10, this.availableJARsViewer.getTable().getItemCount());
            data.heightHint = this.availableJARsViewer.getTable().getItemHeight() * numlines;
            this.availableJARsViewer.getTable().setLayoutData((Object)data);
            this.refreshCheckedItems();
            this.updateButtonEnablements();
        } else {
            this.availableJARsViewer.setInput((Object)this.model.getClassPathSelectionForWLPs());
            GridData data = new GridData(1808);
            int numlines = Math.min(10, this.availableJARsViewer.getTable().getItemCount());
            data.heightHint = this.availableJARsViewer.getTable().getItemHeight() * numlines;
            this.availableJARsViewer.getTable().setLayoutData((Object)data);
            this.refreshWLPCheckedItems();
        }
    }

    private void refreshWLPCheckedItems() {
        if (this.availableJARsViewer.getInput() != null) {
            List elements = ((ClassPathSelection)this.availableJARsViewer.getInput()).getClasspathElements();
            int i = 0;
            while (i < elements.size()) {
                ClasspathElement element = (ClasspathElement)elements.get(i);
                this.availableJARsViewer.setChecked((Object)element, element.isSelected());
                if (element.isClasspathDependency()) {
                    this.availableJARsViewer.setGrayed((Object)element, true);
                }
                ++i;
            }
        }
    }

    public ClasspathModel getModel() {
        return this.model;
    }

    public void setModel(ClasspathModel model) {
        this.model = model;
        this.initializeEJBClientDefaults();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isWLPEntry() {
        return this.model.isWLPModel();
    }

    public void setWLPEntry(boolean isWLPEntry) {
        this.isWLPEntry = isWLPEntry;
    }
}

