/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public class ImportsFix
extends AbstractFix {
    public static IFix createCleanUp(final JavaScriptUnit cu, CodeGenerationSettings settings, boolean organizeImports, RefactoringStatus status) throws CoreException {
        TextEdit edit;
        if (!organizeImports) {
            return null;
        }
        OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

            @Override
            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                throw new AmbiguousImportException();
            }
        };
        OrganizeImportsOperation op = new OrganizeImportsOperation((IJavaScriptUnit)cu.getJavaElement(), cu, settings.importIgnoreLowercase, false, false, query);
        try {
            edit = op.createTextEdit(null);
        }
        catch (AmbiguousImportException ambiguousImportException) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unresolvable, ImportsFix.getLocationString(cu)));
            return null;
        }
        if (op.getParseError() != null) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_parse, ImportsFix.getLocationString(cu)));
            return null;
        }
        if (edit == null) {
            return null;
        }
        if (op.getNumberOfImportsAdded() == 0 && op.getNumberOfImportsRemoved() == 0) {
            return null;
        }
        return new IFix(){

            @Override
            public TextChange createChange() throws CoreException {
                CompilationUnitChange result = new CompilationUnitChange(this.getDescription(), this.getCompilationUnit());
                result.setEdit(edit);
                String label = this.getDescription();
                result.addTextEditGroup((TextEditGroup)new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label))));
                return result;
            }

            @Override
            public IJavaScriptUnit getCompilationUnit() {
                return (IJavaScriptUnit)cu.getJavaElement();
            }

            @Override
            public String getDescription() {
                return FixMessages.ImportsFix_OrganizeImports_Description;
            }

            @Override
            public IStatus getStatus() {
                return StatusInfo.OK_STATUS;
            }
        };
    }

    private static String getLocationString(JavaScriptUnit cu) {
        return cu.getJavaElement().getPath().makeRelative().toString();
    }

    protected ImportsFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class AmbiguousImportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AmbiguousImportException() {
        }
    }
}

