/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.Logger;
import org.eclipse.wst.jsdt.internal.ui.text.java.MemberProposalInfo;

public final class FieldProposalInfo
extends MemberProposalInfo {
    public FieldProposalInfo(IJavaScriptProject project, CompletionProposal proposal) {
        super(project, proposal);
    }

    @Override
    public IJavaScriptElement getJavaElement() throws JavaScriptModelException {
        if (!this.fJavaElementResolved) {
            this.fJavaElementResolved = true;
            this.fElement = this.resolve();
        }
        return this.fElement;
    }

    @Override
    protected IMember resolveMember() throws JavaScriptModelException {
        IMember member = null;
        IJavaScriptElement element = this.resolve();
        if (element instanceof IMember) {
            member = (IMember)element;
        }
        return member;
    }

    private IJavaScriptElement resolve() throws JavaScriptModelException {
        char[] declarationSignature;
        char[] typeNameChars = this.fProposal.getDeclarationTypeName();
        String declaringTypeName = null;
        if (typeNameChars != null) {
            declaringTypeName = String.valueOf(typeNameChars);
        }
        if (declaringTypeName == null && (declarationSignature = this.fProposal.getDeclarationSignature()) != null) {
            declaringTypeName = SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature));
        }
        IField resolvedField = null;
        if (declaringTypeName != null) {
            String fieldName = String.valueOf(this.fProposal.getName());
            IType[] types = this.fJavaProject.findTypes(declaringTypeName);
            if (types != null && types.length > 0) {
                int i = 0;
                while (i < types.length && resolvedField == null) {
                    IField field;
                    IType type = types[i];
                    if (type != null && (field = type.getField(fieldName)).exists()) {
                        resolvedField = field;
                    }
                    ++i;
                }
            } else {
                char[][] seperatedDeclaringTypename = QualificationHelpers.seperateFullyQualifedName((char[])declaringTypeName.toCharArray());
                FieldPattern fieldPattern = new FieldPattern(true, false, false, fieldName.toCharArray(), seperatedDeclaringTypename[0], seperatedDeclaringTypename[1], 0);
                SearchEngine searchEngine = new SearchEngine((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.fJavaProject});
                final ArrayList matches = new ArrayList();
                try {
                    searchEngine.search((SearchPattern)fieldPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IField || element instanceof ILocalVariable) {
                                matches.add(element);
                            }
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Logger.logException("Failed index search for field: " + fieldName, (Throwable)e);
                }
                if (!matches.isEmpty()) {
                    resolvedField = (IJavaScriptElement)matches.get(0);
                }
            }
        }
        return resolvedField;
    }
}

